/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;

public abstract class WidgetBase
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    protected final int x;
    protected final int y;
    protected int zOffset;
    protected final Minecraft minecraft;
    protected final Font font;
    private int height;
    private int width;
    protected boolean isHovered;
    private boolean visible = true;

    protected WidgetBase(Position position, Dimension dimension) {
        this.x = position.x();
        this.y = position.y();
        this.width = dimension.width();
        this.height = dimension.height();
        this.minecraft = Minecraft.m_91087_();
        this.font = this.minecraft.f_91062_;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.zOffset != 0) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, (double)this.zOffset);
        }
        RenderSystem.m_69482_();
        this.renderBg(matrixStack, this.minecraft, mouseX, mouseY);
        this.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
        if (this.zOffset != 0) {
            matrixStack.m_85849_();
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.isHovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    protected abstract void renderBg(PoseStack var1, Minecraft var2, int var3, int var4);

    protected abstract void renderWidget(PoseStack var1, int var2, int var3, float var4);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.getWidth()) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.getHeight());
    }

    public void setZOffset(int zOffset) {
        this.zOffset = zOffset;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected int getCenteredX(int elementWidth) {
        return (this.getWidth() - elementWidth) / 2;
    }

    public void renderTooltip(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
    }
}

