/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;

public class ItemDisplaySettingsContainer
extends SettingsContainerBase<ItemDisplaySettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String COLOR_TAG = "color";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String UNSELECT_SLOT_ACTION = "unselectSlot";
    private static final String ROTATE_CLOCKWISE_ACTION = "rotateClockwise";
    private static final String ROTATE_COUNTER_CLOCKWISE_ACTION = "rotateCounterClockwise";

    public ItemDisplaySettingsContainer(SettingsContainer<?> settingsContainer, String categoryName, ItemDisplaySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(ACTION_TAG)) {
            switch (data.m_128461_(ACTION_TAG)) {
                case "unselectSlot": {
                    this.unselectSlot();
                    break;
                }
                case "rotateClockwise": {
                    this.rotateClockwise();
                    break;
                }
                case "rotateCounterClockwise": {
                    this.rotateCounterClockwise();
                    break;
                }
            }
        } else if (data.m_128441_(SELECT_SLOT_TAG)) {
            this.selectSlot(data.m_128451_(SELECT_SLOT_TAG));
        } else if (data.m_128441_(COLOR_TAG)) {
            this.setColor(DyeColor.m_41053_((int)data.m_128451_(COLOR_TAG)));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        this.unselectSlot();
    }

    private void unselectSlot() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_SLOT_ACTION);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void rotateClockwise() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(true);
        } else {
            this.sendStringToServer(ACTION_TAG, ROTATE_CLOCKWISE_ACTION);
        }
    }

    public void rotateCounterClockwise() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(false);
        } else {
            this.sendStringToServer(ACTION_TAG, ROTATE_COUNTER_CLOCKWISE_ACTION);
        }
    }

    public void setColor(DyeColor color) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.m_41060_());
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlot().map(s -> s == slotNumber).orElse(false);
    }

    public DyeColor getColor() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getColor();
    }

    public int getRotation() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getRotation();
    }

    public Optional<Integer> getSlot() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlot();
    }
}

