/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CookingLogic<T extends AbstractCookingRecipe> {
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private ItemStackHandler cookingInventory = null;
    public static final int COOK_INPUT_SLOT = 0;
    public static final int COOK_OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 1;
    @Nullable
    private T cookingRecipe = null;
    private boolean cookingRecipeInitialized = false;
    private final float burnTimeModifier;
    private final Predicate<ItemStack> isFuel;
    private final Predicate<ItemStack> isInput;
    private final double cookingSpeedMultiplier;
    private final double fuelEfficiencyMultiplier;
    private final RecipeType<T> recipeType;
    private boolean paused = false;
    private long remainingCookTime = 0L;
    private long remainingBurnTime = 0L;

    public CookingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, CookingUpgradeConfig cookingUpgradeConfig, RecipeType<T> recipeType, float burnTimeModifier) {
        this(upgrade, saveHandler, s -> CookingLogic.getBurnTime(s, recipeType, burnTimeModifier) > 0, s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), cookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    public CookingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, Predicate<ItemStack> isFuel, Predicate<ItemStack> isInput, CookingUpgradeConfig cookingUpgradeConfig, RecipeType<T> recipeType, float burnTimeModifier) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.isFuel = isFuel;
        this.isInput = isInput;
        this.cookingSpeedMultiplier = (Double)cookingUpgradeConfig.cookingSpeedMultiplier.get();
        this.fuelEfficiencyMultiplier = (Double)cookingUpgradeConfig.fuelEfficiencyMultiplier.get();
        this.recipeType = recipeType;
        this.burnTimeModifier = burnTimeModifier;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean tick(Level world) {
        this.updateTimes(world);
        AtomicBoolean didSomething = new AtomicBoolean(true);
        if (this.isBurning(world) || this.readyToStartCooking()) {
            Optional<AbstractCookingRecipe> fr = this.getCookingRecipe();
            if (fr.isEmpty() && this.isCooking()) {
                this.setIsCooking(false);
            }
            fr.ifPresent(recipe -> {
                this.updateFuel(world, recipe);
                if (this.isBurning(world) && this.canSmelt((Recipe<?>)recipe)) {
                    this.updateCookingProgress(world, recipe);
                } else if (!this.isBurning(world)) {
                    didSomething.set(false);
                }
            });
        }
        if (!this.isBurning(world) && this.isCooking()) {
            this.updateCookingCooldown(world);
        } else {
            didSomething.set(false);
        }
        return didSomething.get();
    }

    private void updateTimes(Level world) {
        if (this.paused) {
            this.unpause(world);
            return;
        }
        this.remainingBurnTime = this.isBurning(world) ? this.getBurnTimeFinish() - world.m_46467_() : 0L;
        this.remainingCookTime = this.isCooking() ? this.getCookTimeFinish() - world.m_46467_() : 0L;
    }

    private void unpause(Level world) {
        this.paused = false;
        if (this.remainingBurnTime > 0L) {
            this.setBurnTimeFinish(world.m_46467_() + this.remainingBurnTime);
        }
        if (this.remainingCookTime > 0L) {
            this.setCookTimeFinish(world.m_46467_() + this.remainingCookTime);
            this.setIsCooking(true);
        }
    }

    public boolean isBurning(Level world) {
        return this.getBurnTimeFinish() >= world.m_46467_();
    }

    private Optional<T> getCookingRecipe() {
        if (!this.cookingRecipeInitialized) {
            this.cookingRecipe = RecipeHelper.getCookingRecipe(this.getCookInput(), this.recipeType).orElse(null);
            this.cookingRecipeInitialized = true;
        }
        return Optional.ofNullable(this.cookingRecipe);
    }

    private void updateCookingCooldown(Level world) {
        if (this.getRemainingCookTime(world) + 2 > this.getCookTimeTotal()) {
            this.setIsCooking(false);
        } else {
            this.setCookTimeFinish(world.m_46467_() + (long)Math.min(this.getRemainingCookTime(world) + 2, this.getCookTimeTotal()));
        }
    }

    private void updateCookingProgress(Level world, T cookingRecipe) {
        if (this.isCooking() && this.finishedCooking(world)) {
            this.smelt((Recipe<?>)cookingRecipe);
            if (this.canSmelt((Recipe<?>)cookingRecipe)) {
                this.setCookTime(world, (int)((double)cookingRecipe.m_43753_() * (1.0 / this.cookingSpeedMultiplier)));
            } else {
                this.setIsCooking(false);
            }
        } else if (!this.isCooking()) {
            this.setIsCooking(true);
            this.setCookTime(world, (int)((double)cookingRecipe.m_43753_() * (1.0 / this.cookingSpeedMultiplier)));
        }
    }

    private boolean finishedCooking(Level world) {
        return this.getCookTimeFinish() <= world.m_46467_();
    }

    private boolean readyToStartCooking() {
        return !this.getFuel().m_41619_() && !this.getCookInput().m_41619_();
    }

    private void smelt(Recipe<?> recipe) {
        if (!this.canSmelt(recipe)) {
            return;
        }
        ItemStack input = this.getCookInput();
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack output = this.getCookOutput();
        if (output.m_41619_()) {
            this.setCookOutput(recipeOutput.m_41777_());
        } else if (output.m_41720_() == recipeOutput.m_41720_()) {
            output.m_41769_(recipeOutput.m_41613_());
            this.setCookOutput(output);
        }
        if (input.m_41720_() == Blocks.f_50057_.m_5456_() && !this.getFuel().m_41619_() && this.getFuel().m_41720_() == Items.f_42446_) {
            this.setFuel(new ItemStack((ItemLike)Items.f_42447_));
        }
        input.m_41774_(1);
        this.setCookInput(input);
    }

    public void setCookInput(ItemStack input) {
        this.cookingInventory.setStackInSlot(0, input);
    }

    private void setCookOutput(ItemStack stack) {
        this.getCookingInventory().setStackInSlot(2, stack);
    }

    private int getRemainingCookTime(Level world) {
        return (int)(this.getCookTimeFinish() - world.m_46467_());
    }

    private void setCookTime(Level world, int cookTime) {
        this.setCookTimeFinish(world.m_46467_() + (long)cookTime);
        this.setCookTimeTotal(cookTime);
    }

    public void pause() {
        this.paused = true;
        this.setCookTimeFinish(0L);
        this.setIsCooking(false);
        this.setBurnTimeFinish(0L);
    }

    private void updateFuel(Level world, T cookingRecipe) {
        ItemStack fuel = this.getFuel();
        if (!this.isBurning(world) && this.canSmelt((Recipe<?>)cookingRecipe)) {
            if (CookingLogic.getBurnTime(fuel, this.recipeType, this.burnTimeModifier) <= 0) {
                return;
            }
            this.setBurnTime(world, (int)((double)CookingLogic.getBurnTime(fuel, this.recipeType, this.burnTimeModifier) * this.fuelEfficiencyMultiplier / this.cookingSpeedMultiplier));
            if (this.isBurning(world)) {
                if (fuel.hasContainerItem()) {
                    this.setFuel(fuel.getContainerItem());
                } else if (!fuel.m_41619_()) {
                    fuel.m_41774_(1);
                    this.setFuel(fuel);
                    if (fuel.m_41619_()) {
                        this.setFuel(fuel.getContainerItem());
                    }
                }
            }
        }
    }

    private void setBurnTime(Level world, int burnTime) {
        this.setBurnTimeFinish(world.m_46467_() + (long)burnTime);
        this.setBurnTimeTotal(burnTime);
    }

    protected boolean canSmelt(Recipe<?> cookingRecipe) {
        if (this.getCookInput().m_41619_()) {
            return false;
        }
        ItemStack recipeOutput = cookingRecipe.m_8043_();
        if (recipeOutput.m_41619_()) {
            return false;
        }
        ItemStack output = this.getCookOutput();
        if (output.m_41619_()) {
            return true;
        }
        if (!output.m_41656_(recipeOutput)) {
            return false;
        }
        if (output.m_41613_() + recipeOutput.m_41613_() <= 64 && output.m_41613_() + recipeOutput.m_41613_() <= output.m_41741_()) {
            return true;
        }
        return output.m_41613_() + recipeOutput.m_41613_() <= recipeOutput.m_41741_();
    }

    private static <T extends AbstractCookingRecipe> int getBurnTime(ItemStack fuel, RecipeType<T> recipeType, float burnTimeModifier) {
        return (int)((float)ForgeHooks.getBurnTime((ItemStack)fuel, recipeType) * burnTimeModifier);
    }

    public ItemStack getCookOutput() {
        return this.getCookingInventory().getStackInSlot(2);
    }

    public ItemStack getCookInput() {
        return this.getCookingInventory().getStackInSlot(0);
    }

    public ItemStack getFuel() {
        return this.getCookingInventory().getStackInSlot(1);
    }

    public void setFuel(ItemStack fuel) {
        this.getCookingInventory().setStackInSlot(1, fuel);
    }

    public ItemStackHandler getCookingInventory() {
        if (this.cookingInventory == null) {
            this.cookingInventory = new ItemStackHandler(3){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    CookingLogic.this.upgrade.m_41700_("cookingInventory", (Tag)this.serializeNBT());
                    CookingLogic.this.save();
                    if (slot == 0) {
                        CookingLogic.this.cookingRecipeInitialized = false;
                    }
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return switch (slot) {
                        case 0 -> CookingLogic.this.isInput.test(stack);
                        case 1 -> CookingLogic.this.isFuel.test(stack);
                        default -> true;
                    };
                }
            };
            NBTHelper.getCompound(this.upgrade, "smeltingInventory").ifPresentOrElse(arg_0 -> ((ItemStackHandler)this.cookingInventory).deserializeNBT(arg_0), () -> NBTHelper.getCompound(this.upgrade, "cookingInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.cookingInventory).deserializeNBT(arg_0)));
        }
        return this.cookingInventory;
    }

    public long getBurnTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "burnTimeFinish").orElse(0L);
    }

    private void setBurnTimeFinish(long burnTimeFinish) {
        NBTHelper.setLong(this.upgrade, "burnTimeFinish", burnTimeFinish);
        this.save();
    }

    public int getBurnTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "burnTimeTotal").orElse(0);
    }

    private void setBurnTimeTotal(int burnTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "burnTimeTotal", burnTimeTotal);
        this.save();
    }

    public long getCookTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "cookTimeFinish").orElse(-1L);
    }

    private void setCookTimeFinish(long cookTimeFinish) {
        NBTHelper.setLong(this.upgrade, "cookTimeFinish", cookTimeFinish);
        this.save();
    }

    public int getCookTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "cookTimeTotal").orElse(0);
    }

    private void setCookTimeTotal(int cookTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "cookTimeTotal", cookTimeTotal);
        this.save();
    }

    public boolean isCooking() {
        return NBTHelper.getBoolean(this.upgrade, "isCooking").orElse(false);
    }

    private void setIsCooking(boolean isCooking) {
        NBTHelper.setBoolean(this.upgrade, "isCooking", isCooking);
        this.save();
    }
}

