/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterRecipeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class StonecutterUpgradeContainer
extends UpgradeContainerBase<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final StonecutterRecipeContainer recipeContainer;

    public StonecutterUpgradeContainer(Player player, int upgradeContainerId, StonecutterUpgradeWrapper upgradeWrapper, UpgradeContainerType<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        ContainerLevelAccess worldPosCallable = player.f_19853_.f_46443_ ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_142538_());
        this.recipeContainer = new StonecutterRecipeContainer(this, this.slots::add, this, worldPosCallable);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else {
            this.recipeContainer.handleMessage(data);
        }
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((StonecutterUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((StonecutterUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    public StonecutterRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    @Override
    public boolean mergeIntoStorageFirst(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot);
    }
}

