/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureUtil {
    private static final BoundingBox DESERT_PYRAMID_BOX = new BoundingBox(-2, -20, -2, 3, 2, 3);
    private static final ResourceLocation DESERT_PYRAMID = new ResourceLocation("minecraft", "desert_pyramid");
    private static final ResourceLocation JUNGLE_PYRAMID = new ResourceLocation("minecraft", "jungle_pyramid");

    @Nullable
    public static StructureFeature<?> featureFor(ServerLevel level, BlockPos pos) {
        ChunkPos cPos = new ChunkPos(pos);
        ChunkAccess chunk = level.m_46819_(cPos.f_45578_, cPos.f_45579_, ChunkStatus.f_62316_);
        StructureFeatureManager manager = level.m_8595_();
        Map references = chunk.m_7049_();
        for (Map.Entry entry : references.entrySet()) {
            LongIterator longIterator = ((LongSet)entry.getValue()).iterator();
            while (longIterator.hasNext()) {
                BlockPos corner;
                BoundingBox additional;
                long i = (Long)longIterator.next();
                SectionPos sec = SectionPos.m_123196_((ChunkPos)new ChunkPos(i), (int)level.m_151560_());
                StructureStart start = manager.m_47297_(sec, (StructureFeature)entry.getKey(), (FeatureAccess)level.m_46819_(sec.m_123170_(), sec.m_123222_(), ChunkStatus.f_62315_));
                if (start == null || !start.m_73603_()) continue;
                BoundingBox box = start.m_73601_();
                if (box.m_162394_().m_123331_((Vec3i)pos) > 225.0) {
                    box = start.m_73610_().m_183606_(StructurePiece.m_192651_(start.m_73602_().stream()));
                }
                if (JUNGLE_PYRAMID.equals((Object)((StructureFeature)entry.getKey()).getRegistryName())) {
                    box = new BoundingBox(box.m_162395_(), box.m_162396_() - 2, box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
                }
                if (box.m_71051_((Vec3i)pos)) {
                    return (StructureFeature)entry.getKey();
                }
                if (!DESERT_PYRAMID.equals((Object)((StructureFeature)entry.getKey()).getRegistryName()) || !(additional = DESERT_PYRAMID_BOX.m_71045_((corner = box.m_162394_()).m_123341_(), corner.m_123342_(), corner.m_123343_())).m_71051_((Vec3i)pos)) continue;
                return (StructureFeature)entry.getKey();
            }
        }
        return null;
    }
}

