/*
 * Decompiled with CFR 0.152.
 */
package net.codersdownunder.flowerseeds;

import net.codersdownunder.flowerseeds.FlowerSeedsItemGroup;
import net.codersdownunder.flowerseeds.init.BlockInit;
import net.codersdownunder.flowerseeds.init.ItemInit;
import net.codersdownunder.flowerseeds.utils.ConfigManager;
import net.codersdownunder.flowerseeds.utils.FlowerSeedsConfig;
import net.codersdownunder.flowerseeds.utils.flags.FlowerSeedsModFlags;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="flowerseeds")
public class FlowerSeeds {
    public static final String MODID = "flowerseeds";
    public static FlowerSeedsItemGroup FLOWERSEEDS_ITEM_GROUP;
    public static Boolean cyclicLoaded;
    public static Boolean terraLoaded;
    public static final Logger LOGGER;

    public FlowerSeeds() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigManager.SERVER);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        ItemInit.ITEMS.register(bus);
        BlockInit.BLOCKS.register(bus);
        ConfigManager.loadConfig(ConfigManager.SERVER, FMLPaths.CONFIGDIR.get().resolve("flowerseeds.toml").toString());
        this.registerFlags();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FLOWERSEEDS_ITEM_GROUP = new FlowerSeedsItemGroup(MODID);
        terraLoaded = ModList.get().isLoaded("terraincognita");
        cyclicLoaded = ModList.get().isLoaded("cyclic");
    }

    private void registerFlags() {
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_DANDELION, (Boolean)FlowerSeedsConfig.dandelionseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_POPPY, (Boolean)FlowerSeedsConfig.poppyseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_ORCHID, (Boolean)FlowerSeedsConfig.orchidseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_ALLIUM, (Boolean)FlowerSeedsConfig.alliumseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_AZURE, (Boolean)FlowerSeedsConfig.azureseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_TULIP_RED, (Boolean)FlowerSeedsConfig.tulip_redseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_TULIP_ORANGE, (Boolean)FlowerSeedsConfig.tulip_orangeseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_TULIP_WHITE, (Boolean)FlowerSeedsConfig.tulip_whiteseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_TULIP_PINK, (Boolean)FlowerSeedsConfig.tulip_pinkseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_OXEYE, (Boolean)FlowerSeedsConfig.oxeyeseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_LILY, (Boolean)FlowerSeedsConfig.lilyseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_WITHERROSE, (Boolean)FlowerSeedsConfig.witherroseseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_CORNFLOWER, (Boolean)FlowerSeedsConfig.cornflowerseed.get());
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_CYANROSE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_DANDELION_PUFF, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_CHICORY, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_YARROW, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_DAFFODIL, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_YELLOW_PRIMROSE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_PINK_PRIMROSE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_PURPLE_PRIMROSE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_FOXGLOVE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_WILD_GARLIC, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_MARIGOLD, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_BLUE_LUPINE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_RED_SNAPDRAGON, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_YELLOW_SNAPDRAGON, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_MAGENTA_SNAPDRAGON, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_EDELWEISS, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_SAXIFRAGE, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_ALPINE_PINK, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_GENTIAN, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_FORGET_ME_NOT, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_GLOBEFLOWER, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_BLUE_IRIS, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_PURPLE_IRIS, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_BLACK_IRIS, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_FIREWEED, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_ARCTIC_POPPY, false);
        FlowerSeedsModFlags.setFlag(FlowerSeedsModFlags.FLAG_WHITE_DRYAD, false);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            float chance = 0.3f;
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.ALLIUM_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.AZURE_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.CORNFLOWER_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.DANDELION_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.LILY_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.ORCHID_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.OXEYE_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.POPPY_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.TULIP_ORANGE_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.TULIP_PINK_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.TULIP_RED_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.TULIP_WHITE_SEED.get()), chance);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ItemInit.WITHERROSE_SEED.get()), chance);
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_DANDELION.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_ALLIUM.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_AZURE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_CORNFLOWER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_LILY.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_ORCHID.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_OXEYE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_POPPY.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_TULIP_ORANGE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_TULIP_PINK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_TULIP_RED.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_TULIP_WHITE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CROP_WITHERROSE.get()), (RenderType)RenderType.m_110463_());
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

