/*
 * Decompiled with CFR 0.152.
 */
package net.codersdownunder.flowerseeds.utils;

import java.util.Random;
import javax.annotation.Nullable;
import net.codersdownunder.flowerseeds.FlowerSeeds;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FlowerSpawnHandler {
    public static Random rand = new Random();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBone(BonemealEvent event) {
        if (event.getBlock().m_60734_() instanceof GrassBlock) {
            FlowerSeeds.LOGGER.info("event cancelled");
            event.setCanceled(true);
            this.applyBoneMeal(event.getWorld(), event.getPos(), event.getBlock(), event.getStack(), event.getPlayer());
        }
    }

    public boolean applyBoneMeal(Level world, BlockPos pos, BlockState state, ItemStack itemStack, @Nullable Player player) {
        if (FlowerSpawnHandler.isGrassBlock(state)) {
            if (!world.f_46443_) {
                Random random = world.f_46441_;
                int tries = 6;
                int range = 6;
                boolean spawnedAnyFlower = false;
                for (int i = 0; i < 6; ++i) {
                    BlockPos flowerPos = new BlockPos(pos.m_123341_() + random.nextInt(12) - 6, pos.m_123342_() + 1, pos.m_123343_() + random.nextInt(12) - 6);
                    if (!world.m_46859_(flowerPos) || !FlowerSpawnHandler.isGrassBlock(world.m_8055_(flowerPos.m_7495_()))) continue;
                    this.plantFlower(world, flowerPos, rand);
                    spawnedAnyFlower = true;
                }
                if (spawnedAnyFlower) {
                    world.m_46796_(2005, pos, 0);
                } else {
                    world.m_46796_(2000, pos.m_7494_(), 4);
                }
            }
            if (player == null || !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private void plantFlower(Level world, BlockPos pos, Random rand) {
        Block block = rand.nextInt(3) == 0 ? Blocks.f_50359_ : Blocks.f_50035_;
        BlockState state = block.m_49966_();
        if (state.m_60710_((LevelReader)world, pos)) {
            world.m_46597_(pos, state);
        }
        world.m_7260_(pos, state, state, 3);
    }

    public void grow(Level world, BlockPos pos, BlockState state, @Nullable Player player) {
        if (FlowerSpawnHandler.isGrassBlock(state)) {
            BlockPos blockpos = pos.m_7494_();
            BlockState blockstate = Blocks.f_50034_.m_49966_();
            block0: for (int i = 0; i < 128; ++i) {
                BlockState blockstate1;
                BlockPos blockpos1 = blockpos;
                for (int j = 0; j < i / 16; ++j) {
                    if (world.m_8055_(blockpos1 = blockpos1.m_142082_(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).m_60838_((BlockGetter)world, blockpos1)) continue block0;
                }
                BlockState blockstate2 = world.m_8055_(blockpos1);
                ((BonemealableBlock)blockstate.m_60734_()).m_7719_(world.m_142572_().m_129783_().m_6018_(), rand, blockpos1, blockstate2);
                if (!blockstate2.m_60795_() || !(blockstate1 = blockstate).m_60710_((LevelReader)world, blockpos1)) continue;
                world.m_7731_(blockpos1, blockstate1, 2);
            }
        }
    }

    public static boolean isGrassBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50440_;
    }
}

