/*
 * Decompiled with CFR 0.152.
 */
package net.codersdownunder.flowerseeds.utils.flags;

import com.google.gson.JsonObject;
import net.codersdownunder.flowerseeds.utils.flags.FlagManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FlagRecipeCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("flowerseeds", "flag");
    private final FlagManager manager;
    private final String flag;

    public FlagRecipeCondition(FlagManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return this.manager.getFlag(this.flag);
    }

    public static class Serializer
    implements IConditionSerializer<FlagRecipeCondition> {
        private final FlagManager manager;
        private final ResourceLocation location;

        public Serializer(FlagManager manager, ResourceLocation location) {
            this.manager = manager;
            this.location = location;
        }

        public void write(JsonObject json, FlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public FlagRecipeCondition read(JsonObject json) {
            return new FlagRecipeCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

