/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public abstract class TeamProperty<T> {
    public final ResourceLocation id;
    public final T defaultValue;

    public TeamProperty(ResourceLocation _id, T def) {
        this.id = _id;
        this.defaultValue = def;
    }

    public abstract TeamPropertyType<T> getType();

    public abstract Optional<T> fromString(String var1);

    public abstract void write(FriendlyByteBuf var1);

    public String toString(T value) {
        return value.toString();
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.id.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TeamProperty) {
            return this.id.equals((Object)((TeamProperty)o).id);
        }
        return false;
    }

    public void writeValue(FriendlyByteBuf buf, T value) {
        buf.m_130072_(this.toString(value), Short.MAX_VALUE);
    }

    public T readValue(FriendlyByteBuf buf) {
        return this.fromString(buf.m_130136_(Short.MAX_VALUE)).orElse(this.defaultValue);
    }

    public void config(ConfigGroup config, TeamPropertyValue<T> value) {
    }

    public Tag toNBT(T value) {
        return StringTag.m_129297_((String)this.toString(value));
    }

    public Optional<T> fromNBT(Tag tag) {
        return this.fromString(tag.m_7916_());
    }
}

