/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entity;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.api.item.BOPItems;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class BoatBOP
extends Boat {
    public BoatBOP(EntityType<? extends BoatBOP> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public BoatBOP(Level level, double x, double y, double z) {
        this(BOPEntities.BOAT, level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("model", this.getModel().getName());
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("model", 8)) {
            this.f_19804_.m_135381_(f_38285_, (Object)ModelType.byName(nbt.m_128461_("model")).ordinal());
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_76153_((Tag)FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public Item m_38369_() {
        switch (ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_))) {
            case FIR: {
                return BOPItems.FIR_BOAT;
            }
            case REDWOOD: {
                return BOPItems.REDWOOD_BOAT;
            }
            case CHERRY: {
                return BOPItems.CHERRY_BOAT;
            }
            case MAHOGANY: {
                return BOPItems.MAHOGANY_BOAT;
            }
            case JACARANDA: {
                return BOPItems.JACARANDA_BOAT;
            }
            case PALM: {
                return BOPItems.PALM_BOAT;
            }
            case WILLOW: {
                return BOPItems.WILLOW_BOAT;
            }
            case DEAD: {
                return BOPItems.DEAD_BOAT;
            }
            case MAGIC: {
                return BOPItems.MAGIC_BOAT;
            }
            case UMBRAN: {
                return BOPItems.UMBRAN_BOAT;
            }
            case HELLBARK: {
                return BOPItems.HELLBARK_BOAT;
            }
        }
        return Items.f_42453_;
    }

    public void setModel(ModelType type) {
        this.f_19804_.m_135381_(f_38285_, (Object)type.ordinal());
    }

    public ModelType getModel() {
        return ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_));
    }

    @Deprecated
    public void m_38332_(Boat.Type vanillaType) {
    }

    @Deprecated
    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public static enum ModelType {
        FIR("fir", BOPBlocks.FIR_PLANKS),
        REDWOOD("redwood", BOPBlocks.REDWOOD_PLANKS),
        CHERRY("cherry", BOPBlocks.CHERRY_PLANKS),
        MAHOGANY("mahogany", BOPBlocks.MAHOGANY_PLANKS),
        JACARANDA("jacaranda", BOPBlocks.JACARANDA_PLANKS),
        PALM("palm", BOPBlocks.PALM_PLANKS),
        WILLOW("willow", BOPBlocks.WILLOW_PLANKS),
        DEAD("dead", BOPBlocks.DEAD_PLANKS),
        MAGIC("magic", BOPBlocks.MAGIC_PLANKS),
        UMBRAN("umbran", BOPBlocks.UMBRAN_PLANKS),
        HELLBARK("hellbark", BOPBlocks.HELLBARK_PLANKS);

        private final String name;
        private final Block planks;

        private ModelType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static ModelType byId(int id) {
            ModelType[] type = ModelType.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static ModelType byName(String aName) {
            ModelType[] type = ModelType.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

