/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BrambleBlock;
import biomesoplenty.common.util.SimpleBlockPredicate;
import biomesoplenty.common.util.biome.GeneratorUtil;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.IPlantable;

public class BrambleFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> {
        BlockState state = world.m_8055_(pos);
        return world.m_8055_(pos).canSustainPlant((BlockGetter)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.f_50746_)) || state.m_60734_() == Blocks.f_50134_;
    };
    protected SimpleBlockPredicate replace = (world, pos) -> world.m_8055_(pos).m_60767_() == Material.f_76296_;

    public BrambleFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        Random rand = featurePlaceContext.m_159776_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.m_142082_(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.placeOn.matches(world, genPos.m_7495_()) || !this.replace.matches(world, genPos)) continue;
            int targetLength = GeneratorUtil.nextIntBetween(rand, 15, 30);
            int height = 0;
            int direction = rand.nextInt(4) + 2;
            block5: for (int length = 0; length <= targetLength && this.replace.matches(world, genPos); ++length) {
                world.m_7731_(genPos, ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, genPos), 2);
                for (Direction face : Direction.values()) {
                    if (world.m_8055_(genPos.m_142300_(face)).m_60734_() != BOPBlocks.BRAMBLE) continue;
                    world.m_7731_(genPos.m_142300_(face), ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, genPos.m_142300_(face)), 2);
                }
                if (rand.nextInt(2) == 0) {
                    direction = rand.nextInt(4) + 2;
                }
                if (rand.nextInt(2) == 0) {
                    int leafDirection = rand.nextInt(6);
                    BlockPos leafPos = genPos.m_142300_(Direction.values()[leafDirection]);
                    if (world.m_46859_(leafPos)) {
                        world.m_7731_(leafPos, (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 19);
                        for (Direction face : Direction.values()) {
                            if (world.m_8055_(leafPos.m_142300_(face)).m_60734_() != BOPBlocks.BRAMBLE) continue;
                            world.m_7731_(leafPos.m_142300_(face), ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, leafPos.m_142300_(face)), 2);
                        }
                    }
                }
                switch (rand.nextInt(6)) {
                    case 0: 
                    case 1: {
                        if (height > 8) continue block5;
                        genPos = genPos.m_7494_();
                        ++height;
                        continue block5;
                    }
                    case 2: {
                        if (height < 0) continue block5;
                        genPos = genPos.m_7495_();
                        --height;
                        continue block5;
                    }
                    default: {
                        genPos = genPos.m_142300_(Direction.values()[direction]);
                    }
                }
            }
        }
        return true;
    }
}

