/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.worldgen.feature.configurations.CypressTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.Material;

public class CypressTreeFeature
extends BOPTreeFeature<CypressTreeConfiguration> {
    public CypressTreeFeature(Codec<CypressTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height, CypressTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int radius = config.trunkWidth - 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_142082_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        BlockPos pos2 = pos.m_142082_(0, height - 2, 0);
        return TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos2);
    }

    public void generateLeafLayer(LevelAccessor world, Random rand, BlockPos pos, int leavesRadius, BiConsumer<BlockPos, BlockState> leaves, CypressTreeConfiguration config) {
        int start = -leavesRadius;
        int end = leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || leavesRadius > 0 && (x == start || x == end || z == start || z == end) && rand.nextDouble() < 0.2) continue;
                this.placeLeaves(world, pos.m_142082_(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(LevelAccessor world, Random rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, CypressTreeConfiguration config) {
        Direction.Axis axis = direction.m_122434_();
        Direction sideways = direction.m_122427_();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.m_5484_(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.m_5484_(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.m_7494_(), leaves, config);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    public boolean m_160510_(WorldGenLevel world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, TreeConfiguration configBase) {
        int leavesHeight;
        CypressTreeConfiguration config = (CypressTreeConfiguration)configBase;
        while (startPos.m_123342_() > 1 && this.canReplace((LevelAccessor)world, startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f));
        int baseLeavesHeight = leavesHeight = height - baseHeight;
        if (leavesHeight < 3) {
            return false;
        }
        leavesHeight = Mth.m_14045_((int)leavesHeight, (int)3, (int)5);
        leavesHeight = Mth.m_14045_((int)(leavesHeight + random.nextInt(3)), (int)0, (int)baseLeavesHeight);
        if (!this.checkSpace((LevelAccessor)world, startPos.m_7494_(), baseHeight, height, config)) {
            return false;
        }
        BlockPos pos = startPos.m_6630_(height);
        this.placeLeaves((LevelAccessor)world, pos, leaves, config);
        pos.m_7495_();
        for (int i = 0; i < leavesHeight; ++i) {
            int radius = 3;
            if (i == 0) {
                radius = 1;
            } else if (i <= 2) {
                radius = 2;
            }
            this.generateLeafLayer((LevelAccessor)world, random, pos, radius, leaves, config);
            pos = pos.m_7495_();
        }
        this.placeSpanishMoss((LevelAccessor)world, random, pos);
        int trunkRadius = config.trunkWidth - 1;
        for (int x = -trunkRadius; x <= trunkRadius; ++x) {
            for (int z = -trunkRadius; z <= trunkRadius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist > trunkRadius) continue;
                int heightHere = height - 1;
                if (dist == 1) {
                    heightHere = (int)((double)height * (0.2 + random.nextDouble() * 0.15));
                }
                heightHere += random.nextInt(2);
                for (int y = 0; y < heightHere; ++y) {
                    BlockPos local = startPos.m_142082_(x, y, z);
                    boolean air = world.m_8055_(local).m_60819_().m_76178_();
                    this.placeLog((LevelAccessor)world, local, logs, config);
                    if (x != 0 || z != 0 || !air || y >= heightHere - leavesHeight + 1) continue;
                    if (y >= baseHeight && random.nextInt(3) == 0) {
                        double theta = Math.PI * random.nextDouble() * 2.0;
                        int length = 2 + random.nextInt(3);
                        BlockPos branchPos = null;
                        for (int i = 0; i < length; ++i) {
                            branchPos = local.m_142022_(Math.cos(theta) * (double)i, (double)(i / 2), Math.sin(theta) * (double)i);
                            this.placeLog((LevelAccessor)world, branchPos, logs, config);
                        }
                        this.generateLeafLayer((LevelAccessor)world, random, branchPos, 2, leaves, config);
                        this.generateLeafLayer((LevelAccessor)world, random, branchPos.m_7494_(), 1, leaves, config);
                        if (random.nextBoolean()) {
                            this.generateLeafLayer((LevelAccessor)world, random, branchPos.m_6630_(2), 0, leaves, config);
                        }
                        this.placeSpanishMoss((LevelAccessor)world, random, branchPos);
                        continue;
                    }
                    if (y < baseHeight || random.nextInt(3) != 0) continue;
                    Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
                    BlockPos offset = local.m_142300_(direction);
                    this.placeLog((LevelAccessor)world, offset, logs, config);
                    for (Direction dir : Direction.values()) {
                        if (!(random.nextDouble() > 0.2)) continue;
                        this.placeLeaves((LevelAccessor)world, offset.m_142300_(dir), leaves, config);
                    }
                    this.placeSpanishMoss((LevelAccessor)world, random, offset);
                }
            }
        }
        return true;
    }

    private void placeSpanishMoss(LevelAccessor p_236429_1_, Random p_236429_2_, BlockPos p_236429_3_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 50; ++i) {
            BlockState blockstate;
            blockpos$mutable.m_122154_((Vec3i)p_236429_3_, p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5), p_236429_2_.nextInt(3) - p_236429_2_.nextInt(3), p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5));
            if (!p_236429_1_.m_46859_((BlockPos)blockpos$mutable) || (blockstate = p_236429_1_.m_8055_(blockpos$mutable.m_7494_())).m_60734_() != BOPBlocks.WILLOW_LEAVES) continue;
            int j = Mth.m_14072_((Random)p_236429_2_, (int)1, (int)3);
            if (p_236429_2_.nextInt(5) == 0) {
                j = 1;
            }
            CypressTreeFeature.placeSpanishMossColumn(p_236429_1_, p_236429_2_, blockpos$mutable, j, 17, 25);
        }
    }

    public static void placeSpanishMossColumn(LevelAccessor p_236427_0_, Random p_236427_1_, BlockPos.MutableBlockPos p_236427_2_, int p_236427_3_, int p_236427_4_, int p_236427_5_) {
        for (int i = 0; i <= p_236427_3_; ++i) {
            if (p_236427_0_.m_46859_((BlockPos)p_236427_2_)) {
                if (i == p_236427_3_ || !p_236427_0_.m_46859_(p_236427_2_.m_7495_())) {
                    p_236427_0_.m_7731_((BlockPos)p_236427_2_, (BlockState)BOPBlocks.SPANISH_MOSS.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)p_236427_1_, (int)p_236427_4_, (int)p_236427_5_))), 2);
                    break;
                }
                p_236427_0_.m_7731_((BlockPos)p_236427_2_, BOPBlocks.SPANISH_MOSS_PLANT.m_49966_(), 2);
            }
            p_236427_2_.m_122173_(Direction.DOWN);
        }
    }

    @Override
    public boolean placeLeaves(LevelAccessor level, BlockPos pos, BiConsumer<BlockPos, BlockState> leaves, CypressTreeConfiguration config) {
        if (TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos)) {
            leaves.accept(pos, config.f_161213_.m_7112_(level.m_5822_(), pos));
            return true;
        }
        return false;
    }

    @Override
    protected boolean canReplace(LevelAccessor level, BlockPos pos) {
        return super.canReplace(level, pos) || level.m_7433_(pos, state -> {
            Material material = state.m_60767_();
            return material == Material.f_76305_;
        });
    }
}

