/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.worldgen.feature.configurations.TwigletTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.Material;

public class TwigletTreeFeature
extends BOPTreeFeature<TwigletTreeConfiguration> {
    public TwigletTreeFeature(Codec<TwigletTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_160510_(WorldGenLevel world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, TreeConfiguration configBase) {
        TwigletTreeConfiguration config = (TwigletTreeConfiguration)configBase;
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        int height = config.minHeight + random.nextInt(1 + config.maxHeight - config.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.m_7494_();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.placeLog((LevelAccessor)world, pos.m_6630_(y), logs, config)) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? config.leafChanceEven : config.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_142082_(1, y, 0), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_142082_(-1, y, 0), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_142082_(0, y, 1), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_142082_(0, y, -1), leaves, config);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos fruitPos = pos.m_142082_(dir.m_122429_(), y, dir.m_122431_());
                BlockState trunkFruit = config.trunkFruitProvider.m_7112_(random, fruitPos);
                if (trunkFruit.m_60734_() == Blocks.f_50016_ || random.nextInt(4) != 0) continue;
                if (trunkFruit.m_60734_() == Blocks.f_50262_) {
                    fruitPos = pos.m_142082_(dir.m_122424_().m_122429_(), 0, dir.m_122424_().m_122431_());
                }
                this.generateTrunkFruit((LevelAccessor)world, random.nextInt(3), fruitPos, dir, config);
            }
        }
        this.placeLeaves((LevelAccessor)world, pos.m_142082_(0, height, 0), leaves, config);
        return true;
    }

    private void generateTrunkFruit(LevelAccessor world, int age, BlockPos pos, Direction direction, TwigletTreeConfiguration config) {
        BlockState trunkFruit = config.trunkFruitProvider.m_7112_(world.m_5822_(), pos);
        if (trunkFruit == Blocks.f_50262_.m_49966_()) {
            if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
                this.m_5974_((LevelWriter)world, pos, (BlockState)((BlockState)trunkFruit.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
            }
        } else if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
            this.m_5974_((LevelWriter)world, pos, (BlockState)trunkFruit.m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        }
    }
}

