/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block.be;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.quark.addons.oddities.block.CrateBlock;
import vazkii.quark.addons.oddities.inventory.CrateMenu;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.handler.SortingHandler;

public class CrateBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private int totalItems = 0;
    private int numPlayersUsing;
    private List<ItemStack> stacks = new ArrayList<ItemStack>();
    private LazyOptional<SidedInvWrapper> wrapper = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.UP));
    private int[] visibleSlots = new int[0];
    boolean needsUpdate = false;
    protected final ContainerData crateData = new ContainerData(){

        public int m_6413_(int index) {
            return index == 0 ? CrateBlockEntity.this.totalItems : CrateBlockEntity.this.stacks.size();
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super(CrateModule.blockEntityType, pos, state);
    }

    public void spillTheTea() {
        SortingHandler.mergeStacks(this.stacks);
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrateBlockEntity be) {
        be.tick();
    }

    public void tick() {
        if (this.needsUpdate) {
            this.stacks.removeIf(ItemStack::m_41619_);
            this.needsUpdate = false;
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("totalItems", this.totalItems);
        ListTag list = new ListTag();
        for (ItemStack stack : this.stacks) {
            CompoundTag stackCmp = new CompoundTag();
            stack.m_41739_(stackCmp);
            list.add((Object)stackCmp);
        }
        compound.m_128365_("stacks", (Tag)list);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.totalItems = nbt.m_128451_("totalItems");
        ListTag list = nbt.m_128437_("stacks", 10);
        this.stacks = new ArrayList<ItemStack>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
    }

    public ItemStack m_8020_(int slot) {
        return slot < this.stacks.size() ? this.stacks.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        if (slot < this.stacks.size()) {
            ItemStack stack = this.m_8020_(slot);
            this.totalItems -= stack.m_41613_();
            this.needsUpdate = true;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackAt = this.m_8020_(slot);
        if (slot >= this.stacks.size()) {
            this.stacks.add(stack);
            this.totalItems += stack.m_41613_();
        } else {
            int sizeDiff = stack.m_41613_() - stackAt.m_41613_();
            this.totalItems += sizeDiff;
            this.stacks.set(slot, stack);
        }
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack stack = this.m_8020_(slot);
        ItemStack retstack = stack.m_41620_(count);
        this.totalItems -= count;
        if (stack.m_41619_()) {
            this.needsUpdate = true;
        }
        return retstack;
    }

    public void m_6596_() {
        super.m_6596_();
        this.totalItems = 0;
        for (ItemStack stack : this.stacks) {
            this.totalItems += stack.m_41613_();
        }
    }

    public int m_6643_() {
        return Math.min(CrateModule.maxItems, this.stacks.size() + 1);
    }

    public void m_6211_() {
        this.stacks.clear();
        this.totalItems = 0;
    }

    public boolean m_7983_() {
        return this.totalItems == 0;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction dir) {
        return true;
    }

    public boolean m_7155_(int index, ItemStack stack, Direction dir) {
        return this.totalItems + stack.m_41613_() <= CrateModule.maxItems;
    }

    public int[] m_7071_(Direction arg0) {
        if (this.visibleSlots.length != this.stacks.size() + 1) {
            this.visibleSlots = new int[this.stacks.size() + 1];
            for (int i = 0; i < this.visibleSlots.length; ++i) {
                this.visibleSlots[i] = i;
            }
        }
        return this.visibleSlots;
    }

    protected Component m_6820_() {
        return new TranslatableComponent(CrateModule.crate.m_7705_());
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CrateMenu(id, player, this, this.crateData);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.wrapper.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.m_58900_();
            boolean flag = (Boolean)blockstate.m_61143_((Property)CrateBlock.PROPERTY_OPEN);
            if (!flag) {
                this.playSound(blockstate, SoundEvents.f_11725_);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 5);
    }

    public void crateTick() {
        int i = this.f_58858_.m_123341_();
        int j = this.f_58858_.m_123342_();
        int k = this.f_58858_.m_123343_();
        this.numPlayersUsing = CrateBlockEntity.calculatePlayersUsing(this.f_58857_, this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.m_58900_();
            if (!blockstate.m_60713_(CrateModule.crate)) {
                this.m_7651_();
                return;
            }
            boolean flag = (Boolean)blockstate.m_61143_((Property)CrateBlock.PROPERTY_OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.f_11724_);
                this.setOpenProperty(blockstate, false);
            }
        }
    }

    public static int calculatePlayersUsing(Level p_213976_0_, BaseContainerBlockEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        for (Player playerentity : p_213976_0_.m_45976_(Player.class, new AABB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            CrateBlockEntity iinventory;
            if (!(playerentity.f_36096_ instanceof CrateMenu) || (iinventory = ((CrateMenu)playerentity.f_36096_).crate) != p_213976_1_) continue;
            ++i;
        }
        return i;
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent sound) {
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }
}

