/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.quark.addons.oddities.block.be.CrateBlockEntity;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.oddities.ScrollCrateMessage;

public class CrateMenu
extends AbstractContainerMenu {
    public final CrateBlockEntity crate;
    public final Inventory playerInv;
    public static final int numRows = 6;
    public static final int numCols = 9;
    public static final int displayedSlots = 54;
    public int scroll = 0;
    private final ContainerData crateData;

    public CrateMenu(int id, Inventory inv, CrateBlockEntity crate) {
        this(id, inv, crate, (ContainerData)new SimpleContainerData(2));
    }

    public CrateMenu(int id, Inventory inv, CrateBlockEntity crate, ContainerData data) {
        super(CrateModule.menuType, id);
        crate.m_5856_(inv.f_35978_);
        this.crate = crate;
        this.playerInv = inv;
        this.crateData = data;
        int i = 36;
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new CrateSlot(k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inv, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inv, i1, 8 + i1 * 18, 161 + i));
        }
        this.m_38884_(this.crateData);
    }

    public int getTotal() {
        return this.crateData.m_6413_(0);
    }

    public int getStackCount() {
        return this.crateData.m_6413_(1);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            boolean empty = false;
            if (index < 54) {
                if (!this.m_38903_(itemstack1, 54, this.f_38839_.size(), true)) {
                    empty = true;
                }
                this.crate.m_6596_();
            } else if (MiscUtil.canPutIntoInv(itemstack, (LevelAccessor)this.crate.m_58904_(), this.crate.m_58899_(), (BlockEntity)this.crate, Direction.UP, true)) {
                MiscUtil.putIntoInv(itemstack, (LevelAccessor)this.crate.m_58904_(), this.crate.m_58899_(), (BlockEntity)this.crate, Direction.UP, false, false);
                itemstack1.m_41764_(0);
                empty = true;
            } else {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                if (slot instanceof CrateSlot) {
                    CrateSlot cslot = (CrateSlot)slot;
                    int target = cslot.getTarget();
                    this.crate.m_8016_(target);
                } else {
                    slot.m_5852_(ItemStack.f_41583_);
                }
            } else if (!empty) {
                slot.m_6654_();
                this.forceSync();
            }
            if (empty) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    public static CrateMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        CrateBlockEntity te = (CrateBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(pos);
        return new CrateMenu(windowId, playerInventory, te);
    }

    public boolean m_6875_(Player playerIn) {
        return this.crate.m_6542_(playerIn);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.crate.m_5785_(playerIn);
    }

    private void forceSync() {
    }

    public void scroll(boolean down, boolean packet) {
        boolean did = false;
        if (down) {
            int target = this.scroll + 9;
            int maxScroll = this.getStackCount() / 9 * 9;
            if (target <= maxScroll) {
                this.scroll = target;
                did = true;
            }
        } else {
            int target = this.scroll - 9;
            if (target >= 0) {
                this.scroll = target;
                did = true;
            }
        }
        if (did) {
            this.m_38946_();
            if (packet) {
                QuarkNetwork.sendToServer(new ScrollCrateMessage(down));
            }
        }
    }

    private class CrateSlot
    extends Slot {
        private final int index;

        public CrateSlot(int index, int xPosition, int yPosition) {
            super((Container)CrateMenu.this.crate, index, xPosition, yPosition);
            this.index = index;
        }

        private int getTarget() {
            Level world = CrateMenu.this.crate.m_58904_();
            return world.f_46443_ ? this.index : this.index + CrateMenu.this.scroll;
        }

        public ItemStack m_7993_() {
            int size;
            int targetIndex = this.getTarget();
            if (targetIndex >= (size = CrateMenu.this.crate.m_6643_())) {
                return ItemStack.f_41583_;
            }
            return CrateMenu.this.crate.m_8020_(targetIndex);
        }

        public void m_5852_(ItemStack stack) {
            int targetIndex = this.getTarget();
            this.f_40218_.m_6836_(targetIndex, stack);
            this.m_6654_();
            CrateMenu.this.forceSync();
        }

        public ItemStack m_6201_(int amount) {
            return this.f_40218_.m_7407_(this.getTarget(), amount);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41613_() + CrateMenu.this.getTotal() <= CrateModule.maxItems;
        }
    }
}

