/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.base.client.config.IngameConfigHandler;
import vazkii.quark.base.client.config.external.ExternalConfigHandler;
import vazkii.quark.base.client.config.screen.AbstractQScreen;
import vazkii.quark.base.client.config.screen.widgets.CheckboxButton;
import vazkii.quark.base.client.config.screen.widgets.IconButton;
import vazkii.quark.base.client.config.screen.widgets.SocialButton;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.ModuleCategory;

public class QuarkConfigHomeScreen
extends AbstractQScreen {
    private static final CubeMap CUBE_MAP = new CubeMap(new ResourceLocation("quark", "textures/misc/panorama/panorama"));
    private static final PanoramaRenderer PANORAMA = new PanoramaRenderer(CUBE_MAP);
    float time;

    public QuarkConfigHomeScreen(Screen parent) {
        super(parent);
    }

    protected void m_7856_() {
        super.m_7856_();
        int perLine = 3;
        boolean addExternal = ExternalConfigHandler.instance.hasAny();
        int pad = 10;
        int vpad = 23;
        int bWidth = 120;
        int left = this.f_96543_ / 2 - (bWidth + pad) * 3 / 2 + 4;
        int vStart = 70;
        int i = 0;
        int catCount = ModuleCategory.values().length + 1;
        if (addExternal) {
            ++catCount;
        }
        boolean shiftedLeft = false;
        int useLeft = left;
        for (ModuleCategory category : ModuleCategory.values()) {
            if (!shiftedLeft && catCount - i < 3) {
                useLeft = this.f_96543_ / 2 - (bWidth + pad) * (catCount - i) / 2;
                shiftedLeft = true;
            }
            int x = useLeft + (bWidth + pad) * (i % 3);
            int y = vStart + i / 3 * vpad;
            IConfigCategory configCategory = IngameConfigHandler.INSTANCE.getConfigCategory(category);
            Component comp = QuarkConfigHomeScreen.componentFor(configCategory);
            IconButton icon = new IconButton(x, y, bWidth - 20, 20, comp, new ItemStack((ItemLike)category.item), this.categoryLink(configCategory));
            CheckboxButton checkbox = new CheckboxButton(x + bWidth - 20, y, IngameConfigHandler.INSTANCE.getCategoryEnabledObject(category));
            this.m_142416_((GuiEventListener)icon);
            this.m_142416_((GuiEventListener)checkbox);
            if (category.requiredMod != null && !ModList.get().isLoaded(category.requiredMod)) {
                icon.f_93623_ = false;
                checkbox.f_93623_ = false;
            }
            ++i;
        }
        IConfigCategory cat = IngameConfigHandler.INSTANCE.getConfigCategory(null);
        this.m_142416_((GuiEventListener)new Button(useLeft + (bWidth + pad) * (i % 3), vStart + i / 3 * vpad, bWidth, 20, QuarkConfigHomeScreen.componentFor(cat), this.categoryLink(cat)));
        ++i;
        if (addExternal) {
            cat = ExternalConfigHandler.instance.mockCategory;
            this.m_142416_((GuiEventListener)new Button(useLeft + (bWidth + pad) * (i % 3), vStart + i / 3 * vpad, bWidth, 20, QuarkConfigHomeScreen.componentFor(cat), this.categoryLink(cat)));
        }
        bWidth = 200;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - bWidth / 2, this.f_96544_ - 30, bWidth, 20, (Component)new TranslatableComponent("quark.gui.config.save"), this::commit));
        vStart = this.f_96544_ - 55;
        bWidth = 20;
        pad = 5;
        left = (this.f_96543_ - (bWidth + pad) * 5) / 2;
        this.m_142416_((GuiEventListener)new SocialButton(left, vStart, (Component)new TranslatableComponent("quark.gui.config.social.website"), 4775356, 0, this.webLink("https://quarkmod.net")));
        this.m_142416_((GuiEventListener)new SocialButton(left + bWidth + pad, vStart, (Component)new TranslatableComponent("quark.gui.config.social.discord"), 7506394, 1, this.webLink("https://discord.gg/vm")));
        this.m_142416_((GuiEventListener)new SocialButton(left + (bWidth + pad) * 2, vStart, (Component)new TranslatableComponent("quark.gui.config.social.patreon"), 16345172, 2, this.webLink("https://patreon.com/vazkii")));
        this.m_142416_((GuiEventListener)new SocialButton(left + (bWidth + pad) * 3, vStart, (Component)new TranslatableComponent("quark.gui.config.social.reddit"), 0xFF4400, 3, this.webLink("https://reddit.com/r/quarkmod")));
        this.m_142416_((GuiEventListener)new SocialButton(left + (bWidth + pad) * 4, vStart, (Component)new TranslatableComponent("quark.gui.config.social.twitter"), 1942002, 4, this.webLink("https://twitter.com/VazkiiMods")));
    }

    private static Component componentFor(IConfigCategory c) {
        TranslatableComponent comp = new TranslatableComponent("quark.category." + c.getName());
        if (c.isDirty()) {
            comp.m_7220_((Component)new TextComponent("*").m_130940_(ChatFormatting.GOLD));
        }
        return comp;
    }

    public void commit(Button button) {
        IngameConfigHandler.INSTANCE.commit();
        this.returnToParent(button);
    }

    @Override
    public void m_6305_(PoseStack mstack, int mouseX, int mouseY, float pticks) {
        this.time += pticks;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            float spin = pticks * 2.0f;
            float blur = 0.85f;
            if (this.time < 20.0f && !GeneralConfig.disableQMenuEffects) {
                spin += 20.0f - this.time;
                blur = this.time / 20.0f * 0.75f + 0.1f;
            }
            PANORAMA.m_110003_(spin, blur);
        } else {
            this.m_7333_(mstack);
        }
        int boxWidth = 400;
        QuarkConfigHomeScreen.m_93172_((PoseStack)mstack, (int)(this.f_96543_ / 2 - boxWidth / 2), (int)0, (int)(this.f_96543_ / 2 + boxWidth / 2), (int)this.f_96544_, (int)0x66000000);
        QuarkConfigHomeScreen.m_93172_((PoseStack)mstack, (int)(this.f_96543_ / 2 - boxWidth / 2 - 1), (int)0, (int)(this.f_96543_ / 2 - boxWidth / 2), (int)this.f_96544_, (int)0x66999999);
        QuarkConfigHomeScreen.m_93172_((PoseStack)mstack, (int)(this.f_96543_ / 2 + boxWidth / 2), (int)0, (int)(this.f_96543_ / 2 + boxWidth / 2 + 1), (int)this.f_96544_, (int)0x66999999);
        super.m_6305_(mstack, mouseX, mouseY, pticks);
        QuarkConfigHomeScreen.m_93208_((PoseStack)mstack, (Font)this.f_96547_, (String)(ChatFormatting.BOLD + I18n.m_118938_((String)"quark.gui.config.header", (Object[])new Object[]{WordUtils.capitalizeFully((String)"quark")})), (int)(this.f_96543_ / 2), (int)15, (int)4775356);
        QuarkConfigHomeScreen.m_93208_((PoseStack)mstack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"quark.gui.config.subheader1", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, ContributorRewardHandler.featuredPatron, ChatFormatting.RESET}), (int)(this.f_96543_ / 2), (int)28, (int)0x9EFFFE);
        QuarkConfigHomeScreen.m_93208_((PoseStack)mstack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"quark.gui.config.subheader2", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)38, (int)0x9EFFFE);
    }
}

