/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.handler;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import vazkii.quark.api.IQuarkButtonAllowed;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.InventoryTransferHandler;
import vazkii.quark.base.module.QuarkModule;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="quark", value={Dist.CLIENT})
public final class InventoryButtonHandler {
    private static final Multimap<ButtonTargetType, ButtonProviderHolder> providers = Multimaps.newSetMultimap(new HashMap(), TreeSet::new);
    private static final Multimap<ButtonTargetType, Button> currentButtons = Multimaps.newSetMultimap(new HashMap(), LinkedHashSet::new);

    @SubscribeEvent
    public static void initGui(ScreenEvent.InitScreenEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = event.getScreen();
        if (GeneralConfig.printScreenClassnames) {
            String print = I18n.m_118938_((String)"quark.misc.opened_screen", (Object[])new Object[]{ChatFormatting.AQUA + screen.getClass().getName()});
            Quark.LOG.info(print);
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_6352_((Component)new TextComponent(print), mc.f_91074_.m_142081_());
            }
        }
        currentButtons.clear();
        if (screen instanceof AbstractContainerScreen && (screen instanceof IQuarkButtonAllowed || GeneralConfig.isScreenAllowed(screen))) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (containerScreen instanceof InventoryScreen || containerScreen.getClass().getName().contains("CuriosScreen")) {
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.PLAYER_INVENTORY, containerScreen, s -> s.f_40218_ == mc.f_91074_.m_150109_() && s.getSlotIndex() == 17);
            } else if (InventoryTransferHandler.accepts(containerScreen.m_6262_(), (Player)mc.f_91074_)) {
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.CONTAINER_INVENTORY, containerScreen, s -> s.f_40218_ != mc.f_91074_.m_150109_() && s.getSlotIndex() == 8);
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.CONTAINER_PLAYER_INVENTORY, containerScreen, s -> s.f_40218_ == mc.f_91074_.m_150109_() && s.getSlotIndex() == 17);
            }
        }
    }

    private static Collection<ButtonProviderHolder> forGui(Screen gui) {
        HashSet<ButtonProviderHolder> holders = new HashSet<ButtonProviderHolder>();
        if (gui instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)gui;
            if (gui instanceof InventoryScreen) {
                holders.addAll(providers.get((Object)ButtonTargetType.PLAYER_INVENTORY));
            } else {
                Minecraft mc = Minecraft.m_91087_();
                if (InventoryTransferHandler.accepts(screen.m_6262_(), (Player)mc.f_91074_)) {
                    holders.addAll(providers.get((Object)ButtonTargetType.CONTAINER_INVENTORY));
                    holders.addAll(providers.get((Object)ButtonTargetType.CONTAINER_PLAYER_INVENTORY));
                }
            }
        }
        return holders;
    }

    @SubscribeEvent
    public static void mouseInputEvent(ScreenEvent.MouseClickedEvent.Pre pressed) {
        Screen gui = pressed.getScreen();
        if (gui instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)gui;
            if (!GeneralConfig.isScreenAllowed(screen)) {
                return;
            }
            Collection<ButtonProviderHolder> holders = InventoryButtonHandler.forGui((Screen)screen);
            for (ButtonProviderHolder holder : holders) {
                if (holder.keybind == null || !holder.keybind.m_90830_(pressed.getButton()) || holder.keybind.getKeyModifier() != KeyModifier.NONE && !holder.keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) continue;
                holder.pressed.accept(screen);
                pressed.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void keyboardInputEvent(ScreenEvent.KeyboardKeyPressedEvent.Post pressed) {
        Screen gui = pressed.getScreen();
        if (gui instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)gui;
            if (!GeneralConfig.isScreenAllowed(screen)) {
                return;
            }
            Collection<ButtonProviderHolder> holders = InventoryButtonHandler.forGui((Screen)screen);
            for (ButtonProviderHolder holder : holders) {
                if (holder.keybind == null || !holder.keybind.m_90832_(pressed.getKeyCode(), pressed.getScanCode()) || holder.keybind.getKeyModifier() != KeyModifier.NONE && !holder.keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) continue;
                holder.pressed.accept(screen);
                pressed.setCanceled(true);
            }
        }
    }

    private static void applyProviders(ScreenEvent.InitScreenEvent.Post event, ButtonTargetType type, AbstractContainerScreen<?> screen, Predicate<Slot> slotPred) {
        Collection holders = providers.get((Object)type);
        if (!holders.isEmpty()) {
            for (Slot slot : screen.m_6262_().f_38839_) {
                if (!slotPred.test(slot)) continue;
                int x = slot.f_40220_ + 6;
                int y = slot.f_40221_ - 13;
                if (screen instanceof BackpackInventoryScreen) {
                    y -= 60;
                }
                for (ButtonProviderHolder holder : holders) {
                    Button button = holder.getButton(screen, x, y);
                    if (button == null) continue;
                    event.addListener((GuiEventListener)button);
                    currentButtons.put((Object)type, (Object)button);
                    x -= 12;
                }
                return;
            }
        }
    }

    public static Collection<Button> getActiveButtons(ButtonTargetType type) {
        return currentButtons.get((Object)type);
    }

    public static void addButtonProvider(QuarkModule module, ButtonTargetType type, int priority, KeyMapping binding, Consumer<AbstractContainerScreen<?>> onKeybind, ButtonProvider provider) {
        providers.put((Object)type, (Object)new ButtonProviderHolder(module, priority, provider, binding, onKeybind));
    }

    public static void addButtonProvider(QuarkModule module, ButtonTargetType type, int priority, String keybindName, Consumer<AbstractContainerScreen<?>> onKeybind, ButtonProvider provider) {
        KeyMapping keybind = ModKeybindHandler.init(keybindName, null, "quark.gui.keygroup.inv");
        keybind.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.GUI);
        InventoryButtonHandler.addButtonProvider(module, type, priority, keybind, onKeybind, provider);
    }

    public static void addButtonProvider(QuarkModule module, ButtonTargetType type, int priority, ButtonProvider provider) {
        providers.put((Object)type, (Object)new ButtonProviderHolder(module, priority, provider));
    }

    public static enum ButtonTargetType {
        PLAYER_INVENTORY,
        CONTAINER_INVENTORY,
        CONTAINER_PLAYER_INVENTORY;

    }

    private static class ButtonProviderHolder
    implements Comparable<ButtonProviderHolder> {
        private final int priority;
        private final QuarkModule module;
        private final ButtonProvider provider;
        private final KeyMapping keybind;
        private final Consumer<AbstractContainerScreen<?>> pressed;

        public ButtonProviderHolder(QuarkModule module, int priority, ButtonProvider provider, KeyMapping keybind, Consumer<AbstractContainerScreen<?>> onPressed) {
            this.module = module;
            this.priority = priority;
            this.provider = provider;
            this.keybind = keybind;
            this.pressed = onPressed;
        }

        public ButtonProviderHolder(QuarkModule module, int priority, ButtonProvider provider) {
            this(module, priority, provider, null, screen -> {});
        }

        @Override
        public int compareTo(@Nonnull ButtonProviderHolder o) {
            return this.priority - o.priority;
        }

        public Button getButton(AbstractContainerScreen<?> parent, int x, int y) {
            return this.module.enabled ? this.provider.provide(parent, x, y) : null;
        }
    }

    public static interface ButtonProvider {
        public Button provide(AbstractContainerScreen<?> var1, int var2, int var3);
    }
}

