/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.quark.base.Quark;

@Mod.EventBusSubscriber(modid="quark")
public class ContributorRewardHandler {
    private static final ImmutableSet<String> DEV_UUID = ImmutableSet.of((Object)"8c826f34-113b-4238-a173-44639c53b6e6", (Object)"0d054077-a977-4b19-9df9-8a4d5bf20ec3", (Object)"458391f5-6303-4649-b416-e4c0d18f837a", (Object)"75c298f9-27c8-415b-9a16-329e3884054b", (Object)"6c175d10-198a-49f9-8e2b-c74f1f0178f3");
    private static final Set<String> done = Collections.newSetFromMap(new WeakHashMap());
    private static Thread thread;
    private static String name;
    private static final Map<String, Integer> tiers;
    public static int localPatronTier;
    public static String featuredPatron;

    @OnlyIn(value=Dist.CLIENT)
    public static void getLocalName() {
        name = Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.ROOT);
    }

    public static void init() {
        if (thread != null && thread.isAlive()) {
            return;
        }
        thread = new ThreadContributorListLoader();
    }

    public static int getTier(Player player) {
        return ContributorRewardHandler.getTier(player.m_36316_().getName());
    }

    public static int getTier(String name) {
        return tiers.getOrDefault(name.toLowerCase(Locale.ROOT), 0);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        AbstractClientPlayer clientPlayer;
        Player player = event.getPlayer();
        String uuid = Player.m_36198_((GameProfile)player.m_36316_()).toString();
        if (player instanceof AbstractClientPlayer && DEV_UUID.contains((Object)uuid) && !done.contains(uuid) && (clientPlayer = (AbstractClientPlayer)player).m_108555_()) {
            PlayerInfo info = ((AbstractClientPlayer)player).f_108546_;
            Map textures = info.f_105299_;
            ResourceLocation loc = new ResourceLocation("quark", "textures/misc/dev_cape.png");
            textures.put(MinecraftProfileTexture.Type.CAPE, loc);
            textures.put(MinecraftProfileTexture.Type.ELYTRA, loc);
            done.add(uuid);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ContributorRewardHandler.init();
    }

    private static void load(Properties props) {
        ArrayList allPatrons = new ArrayList(props.size());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            String value = (String)v;
            int tier = Integer.parseInt(value);
            if (tier < 10) {
                allPatrons.add(key);
            }
            tiers.put(key.toLowerCase(Locale.ROOT), tier);
            if (name != null && key.toLowerCase(Locale.ROOT).equals(name)) {
                localPatronTier = tier;
            }
        }));
        if (!allPatrons.isEmpty()) {
            featuredPatron = (String)allPatrons.get((int)(Math.random() * (double)allPatrons.size()));
        }
    }

    static {
        tiers = new HashMap<String, Integer>();
        localPatronTier = 0;
        featuredPatron = "N/A";
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Quark Contributor Loading Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Quark/master/contributors.properties");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                Properties patreonTiers = new Properties();
                try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
                    patreonTiers.load(reader);
                    ContributorRewardHandler.load(patreonTiers);
                }
            }
            catch (IOException e) {
                Quark.LOG.error("Failed to load patreon information", (Throwable)e);
            }
        }
    }
}

