/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.ICollateralMover;
import vazkii.quark.api.IConditionalSticky;
import vazkii.quark.api.IIndirectConnector;
import vazkii.quark.base.handler.GeneralConfig;

public class QuarkPistonStructureResolver
extends PistonStructureResolver {
    private final PistonStructureResolver parent;
    private final Level world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final Direction moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public QuarkPistonStructureResolver(PistonStructureResolver parent, Level worldIn, BlockPos posIn, Direction pistonFacing, boolean extending) {
        super(worldIn, posIn, pistonFacing, extending);
        this.parent = parent;
        this.world = worldIn;
        this.pistonPos = posIn;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = posIn.m_142300_(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.m_122424_();
            this.blockToMove = posIn.m_5484_(pistonFacing, 2);
        }
    }

    public boolean m_60422_() {
        if (!GeneralConfig.usePistonLogicRepl) {
            return this.parent.m_60422_();
        }
        this.toMove.clear();
        this.toDestroy.clear();
        BlockState iblockstate = this.world.m_8055_(this.blockToMove);
        if (!PistonBaseBlock.m_60204_((BlockState)iblockstate, (Level)this.world, (BlockPos)this.blockToMove, (Direction)this.moveDirection, (boolean)false, (Direction)this.moveDirection)) {
            if (iblockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos blockpos = this.toMove.get(i);
            if (this.addBranchingBlocks(this.world, blockpos, this.isBlockBranching(this.world, blockpos)) != ICollateralMover.MoveResult.PREVENT) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, Direction face) {
        BlockPos movePos;
        int max = GeneralConfig.pistonPushLimit;
        BlockPos target = origin;
        BlockState iblockstate = this.world.m_8055_(target);
        if (iblockstate.m_60795_() || !PistonBaseBlock.m_60204_((BlockState)iblockstate, (Level)this.world, (BlockPos)origin, (Direction)this.moveDirection, (boolean)false, (Direction)face) || origin.equals((Object)this.pistonPos) || this.toMove.contains(origin)) {
            return true;
        }
        int lineLen = 1;
        if (lineLen + this.toMove.size() > max) {
            return false;
        }
        BlockPos oldPos = origin;
        BlockState oldState = this.world.m_8055_(origin);
        boolean skippingNext = false;
        while (this.isBlockBranching(this.world, target)) {
            ICollateralMover.MoveResult res = this.getBranchResult(this.world, target);
            if (res == ICollateralMover.MoveResult.PREVENT) {
                return false;
            }
            if (res != ICollateralMover.MoveResult.MOVE) {
                skippingNext = true;
                break;
            }
            target = origin.m_5484_(this.moveDirection.m_122424_(), lineLen);
            iblockstate = this.world.m_8055_(target);
            if (iblockstate.m_60795_() || !PistonBaseBlock.m_60204_((BlockState)iblockstate, (Level)this.world, (BlockPos)target, (Direction)this.moveDirection, (boolean)false, (Direction)this.moveDirection.m_122424_()) || target.equals((Object)this.pistonPos) || this.getStickCompatibility(this.world, iblockstate, oldState, target, oldPos, this.moveDirection) != ICollateralMover.MoveResult.MOVE) break;
            oldState = iblockstate;
            oldPos = target;
            if (++lineLen + this.toMove.size() <= max) continue;
            return false;
        }
        int i1 = 0;
        for (int j = lineLen - 1; j >= 0 && !this.toDestroy.contains(movePos = origin.m_5484_(this.moveDirection.m_122424_(), j)); --j) {
            this.toMove.add(movePos);
            ++i1;
        }
        if (skippingNext) {
            return true;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1 = origin.m_5484_(this.moveDirection, j1);
            int k = this.toMove.indexOf(blockpos1);
            ICollateralMover.MoveResult res = ICollateralMover.MoveResult.MOVE;
            if (k > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos blockpos2 = this.toMove.get(l);
                    res = this.addBranchingBlocks(this.world, blockpos2, this.isBlockBranching(this.world, blockpos2));
                    if (res != ICollateralMover.MoveResult.PREVENT) continue;
                    return false;
                }
                return true;
            }
            if (res != ICollateralMover.MoveResult.MOVE) continue;
            iblockstate = this.world.m_8055_(blockpos1);
            if (iblockstate.m_60795_()) {
                return true;
            }
            if (!PistonBaseBlock.m_60204_((BlockState)iblockstate, (Level)this.world, (BlockPos)blockpos1, (Direction)this.moveDirection, (boolean)true, (Direction)this.moveDirection) || blockpos1.equals((Object)this.pistonPos)) {
                return false;
            }
            if (iblockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                this.toMove.remove(blockpos1);
                return true;
            }
            boolean doneFinding = false;
            if (this.isBlockBranching(this.world, blockpos1)) {
                res = this.getBranchResult(this.world, blockpos1);
                if (res == ICollateralMover.MoveResult.PREVENT) {
                    return false;
                }
                if (res != ICollateralMover.MoveResult.MOVE) {
                    doneFinding = true;
                }
            }
            if (this.toMove.size() >= max) {
                return false;
            }
            this.toMove.add(blockpos1);
            ++i1;
            ++j1;
            if (doneFinding) break;
        }
        return true;
    }

    private void reorderListAtCollision(int p_177255_1_, int p_177255_2_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, p_177255_2_));
        list1.addAll(this.toMove.subList(this.toMove.size() - p_177255_1_, this.toMove.size()));
        list2.addAll(this.toMove.subList(p_177255_2_, this.toMove.size() - p_177255_1_));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private ICollateralMover.MoveResult addBranchingBlocks(Level world, BlockPos fromPos, boolean isSourceBranching) {
        BlockState state = world.m_8055_(fromPos);
        Block block = state.m_60734_();
        Direction opposite = this.moveDirection.m_122424_();
        ICollateralMover.MoveResult retResult = ICollateralMover.MoveResult.SKIP;
        for (Direction face : Direction.values()) {
            IIndirectConnector indirect;
            ICollateralMover.MoveResult res = ICollateralMover.MoveResult.MOVE;
            BlockPos targetPos = fromPos.m_142300_(face);
            BlockState targetState = world.m_8055_(targetPos);
            res = !isSourceBranching ? ((indirect = QuarkPistonStructureResolver.getIndirectStickiness(targetState)) != null && indirect.isEnabled() && indirect.canConnectIndirectly(world, targetPos, fromPos, targetState, state) ? this.getStickCompatibility(world, state, targetState, fromPos, targetPos, face) : ICollateralMover.MoveResult.SKIP) : (block instanceof ICollateralMover ? ((ICollateralMover)block).getCollateralMovement(world, this.pistonPos, this.moveDirection, face, fromPos) : this.getStickCompatibility(world, state, targetState, fromPos, targetPos, face));
            switch (res) {
                case PREVENT: {
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case MOVE: {
                    if (this.addBlockLine(targetPos, face)) break;
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case BREAK: {
                    if (PistonBaseBlock.m_60204_((BlockState)targetState, (Level)world, (BlockPos)targetPos, (Direction)this.moveDirection, (boolean)true, (Direction)this.moveDirection)) {
                        this.toDestroy.add(targetPos);
                        this.toMove.remove(targetPos);
                        return ICollateralMover.MoveResult.BREAK;
                    }
                    return ICollateralMover.MoveResult.PREVENT;
                }
            }
            if (face != opposite) continue;
            retResult = res;
        }
        return retResult;
    }

    private boolean isBlockBranching(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        return block instanceof ICollateralMover ? ((ICollateralMover)block).isCollateralMover(world, this.pistonPos, this.moveDirection, pos) : QuarkPistonStructureResolver.isBlockSticky(state);
    }

    private ICollateralMover.MoveResult getBranchResult(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ICollateralMover) {
            return ((ICollateralMover)block).getCollateralMovement(world, this.pistonPos, this.moveDirection, this.moveDirection, pos);
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    private ICollateralMover.MoveResult getStickCompatibility(Level world, BlockState state1, BlockState state2, BlockPos pos1, BlockPos pos2, Direction face) {
        IConditionalSticky stick = this.getStickCondition(state1);
        if (stick != null && !stick.canStickToBlock(world, this.pistonPos, pos1, pos2, state1, state2, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        stick = this.getStickCondition(state2);
        if (stick != null && !stick.canStickToBlock(world, this.pistonPos, pos2, pos1, state2, state1, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    private IConditionalSticky getStickCondition(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50719_) {
            return HoneyStickCondition.INSTANCE;
        }
        if (block instanceof IConditionalSticky) {
            return (IConditionalSticky)block;
        }
        IIndirectConnector indirect = QuarkPistonStructureResolver.getIndirectStickiness(state);
        if (indirect != null && indirect.isEnabled()) {
            return indirect.getStickyCondition();
        }
        return null;
    }

    @Nonnull
    public List<BlockPos> m_60436_() {
        if (!GeneralConfig.usePistonLogicRepl) {
            return this.parent.m_60436_();
        }
        return this.toMove;
    }

    @Nonnull
    public List<BlockPos> m_60437_() {
        if (!GeneralConfig.usePistonLogicRepl) {
            return this.parent.m_60437_();
        }
        return this.toDestroy;
    }

    private static IIndirectConnector getIndirectStickiness(BlockState state) {
        for (Pair<Predicate<BlockState>, IIndirectConnector> p : IIndirectConnector.INDIRECT_STICKY_BLOCKS) {
            if (!((Predicate)p.getLeft()).test(state)) continue;
            return (IIndirectConnector)p.getRight();
        }
        return null;
    }

    private static boolean isBlockSticky(BlockState state) {
        if (state.isStickyBlock()) {
            return true;
        }
        IIndirectConnector indirect = QuarkPistonStructureResolver.getIndirectStickiness(state);
        return indirect != null && indirect.isEnabled();
    }

    private static class HoneyStickCondition
    implements IConditionalSticky {
        private static final HoneyStickCondition INSTANCE = new HoneyStickCondition();

        private HoneyStickCondition() {
        }

        @Override
        public boolean canStickToBlock(Level world, BlockPos pistonPos, BlockPos pos, BlockPos slimePos, BlockState state, BlockState slimeState, Direction direction) {
            Block block = state.m_60734_();
            Block slime = slimeState.m_60734_();
            return !slime.isStickyBlock(slimeState) || block == slime;
        }
    }
}

