/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class StructureBlockReplacementHandler {
    public static List<StructureFunction> functions = new ArrayList<StructureFunction>();
    private static ThreadLocal<StructureHolder> structureHolder = new ThreadLocal();

    public static BlockState getResultingBlockState(BlockState blockstate) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentSturctureHolder();
        if (curr != null && curr.currentStructure != null) {
            for (StructureFunction fun : functions) {
                BlockState res = (BlockState)fun.apply(blockstate, curr);
                if (res == null) continue;
                return res;
            }
        }
        return blockstate;
    }

    private static StructureHolder getCurrentSturctureHolder() {
        return structureHolder.get();
    }

    public static void setActiveStructure(StructureFeature<?> structure, PiecesContainer components) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentSturctureHolder();
        if (curr == null) {
            curr = new StructureHolder();
            structureHolder.set(curr);
        }
        curr.currentStructure = structure;
        curr.currentComponents = components == null ? null : components.f_192741_();
    }

    public static class StructureHolder {
        public StructureFeature<?> currentStructure;
        public List<StructurePiece> currentComponents;
    }

    public static interface StructureFunction
    extends BiFunction<BlockState, StructureHolder, BlockState> {
    }
}

