/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vazkii.quark.base.module.QuarkModule;

public final class UndergroundBiomeHandler {
    private static Proxy proxy = null;

    public static void init(FMLCommonSetupEvent event) {
        UndergroundBiomeHandler.proxy().init(event);
    }

    public static void addUndergroundBiomes(OverworldBiomeBuilder builder, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        UndergroundBiomeHandler.proxy().addUndergroundBiomes(builder, consumer);
    }

    public static void addUndergroundBiome(QuarkModule module, Climate.ParameterPoint climate, ResourceLocation biome) {
        UndergroundBiomeSkeleton skeleton = new UndergroundBiomeSkeleton(module, climate, biome);
        UndergroundBiomeHandler.proxy().addUndergroundBiome(skeleton);
    }

    private static Proxy proxy() {
        if (proxy == null) {
            if (ModList.get().isLoaded("terrablender")) {
                try {
                    Class<?> clazz = Class.forName("vazkii.quark.integration.terrablender.TerraBlenderIntegration");
                    Supplier supplier = (Supplier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    proxy = (Proxy)supplier.get();
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (proxy == null) {
                proxy = new Proxy();
            }
        }
        return proxy;
    }

    public static class Proxy {
        public List<UndergroundBiomeSkeleton> skeletons = new ArrayList<UndergroundBiomeSkeleton>();

        public void init(FMLCommonSetupEvent event) {
        }

        public void addUndergroundBiomes(OverworldBiomeBuilder builder, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            for (UndergroundBiomeSkeleton skeleton : this.skeletons) {
                if (!skeleton.module().enabled) continue;
                ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)skeleton.biome());
                consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)skeleton.climate(), (Object)resourceKey));
            }
        }

        public void addUndergroundBiome(UndergroundBiomeSkeleton skeleton) {
            this.skeletons.add(skeleton);
        }
    }

    public record UndergroundBiomeSkeleton(QuarkModule module, Climate.ParameterPoint climate, ResourceLocation biome) {
    }
}

