/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.text.WordUtils;
import org.objectweb.asm.Type;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

public final class ModuleFinder {
    private static final Type LOAD_MODULE_TYPE = Type.getType(LoadModule.class);
    private Map<Class<? extends QuarkModule>, QuarkModule> foundModules = new HashMap<Class<? extends QuarkModule>, QuarkModule>();

    public void findModules() {
        ModFileScanData scanData = ModList.get().getModFileById("quark").getFile().getScanResult();
        scanData.getAnnotations().stream().filter(annotationData -> LOAD_MODULE_TYPE.equals((Object)annotationData.annotationType())).sorted((d1, d2) -> d1.getClass().getName().compareTo(d2.getClass().getName())).forEach(this::loadModule);
    }

    private void loadModule(ModFileScanData.AnnotationData target) {
        try {
            String mod;
            Type type = target.clazz();
            Class<?> clazz = Class.forName(type.getClassName(), false, Quark.class.getClassLoader());
            QuarkModule moduleObj = (QuarkModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map vals = target.annotationData();
            ModuleCategory category = this.getOrMakeCategory((ModAnnotation.EnumHolder)vals.get("category"));
            if (category.isAddon() && (mod = category.requiredMod) != null && !mod.isEmpty() && !ModList.get().isLoaded(mod)) {
                moduleObj.missingDep = true;
            }
            moduleObj.displayName = vals.containsKey("name") ? (String)vals.get("name") : WordUtils.capitalizeFully((String)clazz.getSimpleName().replaceAll("Module$", "").replaceAll("(?<=.)([A-Z])", " $1"));
            moduleObj.lowercaseName = moduleObj.displayName.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            if (vals.containsKey("description")) {
                moduleObj.description = (String)vals.get("description");
            }
            if (vals.containsKey("antiOverlap")) {
                moduleObj.antiOverlap = (List)vals.get("antiOverlap");
            }
            if (vals.containsKey("hasSubscriptions")) {
                moduleObj.hasSubscriptions = (Boolean)vals.get("hasSubscriptions");
            }
            if (vals.containsKey("subscribeOn")) {
                EnumSet<Dist> subscribeTargets = EnumSet.noneOf(Dist.class);
                List holders = (List)vals.get("subscribeOn");
                for (ModAnnotation.EnumHolder holder : holders) {
                    subscribeTargets.add(Dist.valueOf((String)holder.getValue()));
                }
                moduleObj.subscriptionTarget = Lists.newArrayList(subscribeTargets);
            }
            if (vals.containsKey("enabledByDefault")) {
                moduleObj.enabledByDefault = (Boolean)vals.get("enabledByDefault");
            }
            category.addModule(moduleObj);
            moduleObj.category = category;
            this.foundModules.put(clazz, moduleObj);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load Module " + target.toString(), e);
        }
    }

    private ModuleCategory getOrMakeCategory(ModAnnotation.EnumHolder category) {
        return ModuleCategory.valueOf(category.getValue());
    }

    public Map<Class<? extends QuarkModule>, QuarkModule> getFoundModules() {
        return this.foundModules;
    }
}

