/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.entity.Gravisand;

public class GravisandBlock
extends QuarkBlock {
    public GravisandBlock(String regname, QuarkModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, module, creativeTab, properties);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.checkRedstone(world, pos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(worldIn, pos);
    }

    private void checkRedstone(Level worldIn, BlockPos pos) {
        boolean powered = worldIn.m_46753_(pos);
        if (powered) {
            worldIn.m_186460_(pos, (Block)this, 2);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return 15;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!worldIn.f_46443_ && this.checkFallable((Level)worldIn, pos)) {
            for (Direction face : Direction.values()) {
                BlockPos offPos = pos.m_142300_(face);
                BlockState offState = worldIn.m_8055_(offPos);
                if (offState.m_60734_() != this) continue;
                worldIn.m_186460_(offPos, (Block)this, 2);
            }
        }
    }

    private boolean checkFallable(Level worldIn, BlockPos pos) {
        if (!worldIn.f_46443_) {
            if (this.tryFall(worldIn, pos, Direction.DOWN)) {
                return true;
            }
            return this.tryFall(worldIn, pos, Direction.UP);
        }
        return false;
    }

    private boolean tryFall(Level worldIn, BlockPos pos, Direction facing) {
        BlockPos target = pos.m_142300_(facing);
        if ((worldIn.m_46859_(target) || GravisandBlock.canFallThrough((LevelReader)worldIn, pos, worldIn.m_8055_(target))) && worldIn.m_46739_(pos)) {
            Gravisand entity = new Gravisand(worldIn, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, facing.m_122430_());
            worldIn.m_7967_((Entity)entity);
            return true;
        }
        return false;
    }

    public static boolean canFallThrough(LevelReader world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        Material material = state.m_60767_();
        return state.m_60795_() || block == Blocks.f_50083_ || material.m_76332_() || material.m_76336_();
    }
}

