/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.module.HedgesModule;
import vazkii.quark.content.world.block.BlossomLeavesBlock;

public class HedgeBlock
extends FenceBlock
implements IQuarkBlock,
IBlockColorProvider {
    private final QuarkModule module;
    final Block leaf;
    private BooleanSupplier enabledSupplier = () -> true;
    public static final BooleanProperty EXTEND = BooleanProperty.m_61465_((String)"extend");

    public HedgeBlock(QuarkModule module, Block fence, Block leaf) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)fence));
        this.module = module;
        this.leaf = leaf;
        if (leaf instanceof BlossomLeavesBlock) {
            String colorName = leaf.getRegistryName().m_135815_().replaceAll("_blossom_leaves", "");
            RegistryHelper.registerBlock((Block)this, (String)(colorName + "_blossom_hedge"));
        } else {
            RegistryHelper.registerBlock((Block)this, (String)leaf.getRegistryName().m_135815_().replaceAll("_leaves", "_hedge"));
        }
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_53329_(BlockState state, boolean isSideSolid, Direction direction) {
        return state.m_60620_(HedgesModule.hedgesTag);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return facing == Direction.UP && (Boolean)state.m_61143_((Property)f_52313_) == false && plantable.getPlantType(world, pos) == PlantType.PLAINS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos down = blockpos.m_7495_();
        BlockState downState = iblockreader.m_8055_(down);
        return (BlockState)super.m_5573_(context).m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(downState.m_60734_() instanceof HedgeBlock));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)f_52313_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.m_60734_() instanceof HedgeBlock));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTEND});
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        BlockState leafState = this.leaf.m_49966_();
        return (state, world, pos, tintIndex) -> colors.m_92577_(leafState, world, pos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        ItemColors colors = Minecraft.m_91087_().getItemColors();
        ItemStack leafStack = new ItemStack((ItemLike)this.leaf);
        return (stack, tintIndex) -> colors.m_92676_(leafStack, tintIndex);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public HedgeBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

