/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import vazkii.quark.content.building.module.RopeModule;

public class RopeBlock
extends QuarkBlock
implements IBlockItemProvider {
    private static final VoxelShape SHAPE = RopeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public RopeBlock(String regname, QuarkModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, module, creativeTab, properties);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public BlockItem provideItemBlock(Block block, Item.Properties properties) {
        return new BlockItem(block, properties){

            public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
                return world.m_8055_(pos).m_60734_() instanceof RopeBlock;
            }
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == this.m_5456_() && !player.m_20163_()) {
                if (this.pullDown(worldIn, pos)) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    worldIn.m_5594_(null, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)worldIn, (BlockPos)this.getBottomPos(worldIn, pos), (Direction)Direction.UP) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                if (stack.m_41720_() == Items.f_42590_) {
                    BlockPos bottomPos = this.getBottomPos(worldIn, pos);
                    BlockState stateAt = worldIn.m_8055_(bottomPos);
                    if (stateAt.m_60767_() == Material.f_76305_) {
                        Vec3 playerPos = player.m_20182_();
                        worldIn.m_6263_(player, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        stack.m_41774_(1);
                        ItemStack bottleStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        if (stack.m_41619_()) {
                            player.m_21008_(hand, bottleStack);
                        } else if (!player.m_150109_().m_36054_(bottleStack)) {
                            player.m_36176_(bottleStack, false);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (this.pullUp(worldIn, pos)) {
                    if (!player.m_7500_() && !player.m_36356_(new ItemStack((ItemLike)this))) {
                        player.m_36176_(new ItemStack((ItemLike)this), false);
                    }
                    worldIn.m_5594_(null, pos, this.f_60446_.m_56775_(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean pullUp(Level world, BlockPos pos) {
        BlockState state;
        BlockPos basePos = pos;
        while ((state = world.m_8055_(pos = pos.m_7495_())).m_60734_() == this) {
        }
        BlockPos ropePos = pos.m_7494_();
        if (ropePos.equals((Object)basePos)) {
            return false;
        }
        world.m_46597_(ropePos, Blocks.f_50016_.m_49966_());
        this.moveBlock(world, pos, ropePos);
        return true;
    }

    public boolean pullDown(Level world, BlockPos pos) {
        BlockState state;
        boolean endRope = false;
        boolean wasAirAtEnd = false;
        while (true) {
            if (!world.m_46739_(pos = pos.m_7495_())) {
                return false;
            }
            state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block == this) continue;
            if (endRope) break;
            endRope = true;
            wasAirAtEnd = world.m_46859_(pos);
        }
        boolean can = wasAirAtEnd || world.m_46859_(pos) || state.m_60767_().m_76336_();
        if (can) {
            BlockPos ropePos = pos.m_7494_();
            this.moveBlock(world, ropePos, pos);
            BlockState ropePosState = world.m_8055_(ropePos);
            if (world.m_46859_(ropePos) || ropePosState.m_60767_().m_76336_()) {
                world.m_46597_(ropePos, this.m_49966_());
                return true;
            }
        }
        return false;
    }

    private BlockPos getBottomPos(Level worldIn, BlockPos pos) {
        RopeBlock block = this;
        while (block == this) {
            pos = pos.m_7495_();
            BlockState state = worldIn.m_8055_(pos);
            block = state.m_60734_();
        }
        return pos;
    }

    private boolean isIllegalBlock(Block block) {
        return block == Blocks.f_50080_ || block == Blocks.f_50723_ || block == Blocks.f_50724_;
    }

    private void moveBlock(Level world, BlockPos srcPos, BlockPos dstPos) {
        BlockEntity target;
        BlockState state = world.m_8055_(srcPos);
        Block block = state.m_60734_();
        if (state.m_60800_((BlockGetter)world, srcPos) == -1.0f || !state.m_60710_((LevelReader)world, dstPos) || state.m_60795_() || state.m_60811_() != PushReaction.NORMAL || this.isIllegalBlock(block)) {
            return;
        }
        BlockEntity tile = world.m_7702_(srcPos);
        if (tile != null) {
            if (RopeModule.forceEnableMoveTileEntities ? PistonsMoveTileEntitiesModule.shouldMoveTE(state) : PistonsMoveTileEntitiesModule.shouldMoveTE(true, state)) {
                return;
            }
            tile.m_7651_();
        }
        FluidState fluidState = world.m_6425_(srcPos);
        world.m_46597_(srcPos, fluidState.m_76188_());
        BlockState nextState = Block.m_49931_((BlockState)state, (LevelAccessor)world, (BlockPos)dstPos);
        if (nextState.m_61147_().contains(BlockStateProperties.f_61362_)) {
            nextState = (BlockState)nextState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(dstPos).m_76152_() == Fluids.f_76193_));
        }
        world.m_46597_(dstPos, nextState);
        if (tile != null && (target = BlockEntity.m_155241_((BlockPos)dstPos, (BlockState)state, (CompoundTag)tile.m_187480_())) != null) {
            world.m_151523_(target);
            target.m_155250_(state);
            target.m_6596_();
        }
        world.m_46672_(dstPos, state.m_60734_());
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos upPos = pos.m_7494_();
        BlockState upState = worldIn.m_8055_(upPos);
        return upState.m_60734_() == this || upState.m_60783_((BlockGetter)worldIn, upPos, Direction.DOWN);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)worldIn.m_8055_(pos)));
            RopeBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 30;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }
}

