/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.content.building.block.MyalitePillarBlock;
import vazkii.quark.content.world.block.MyaliteBlock;
import vazkii.quark.content.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreStoneVariantsModule
extends QuarkModule {
    @Config(flag="stone_bricks")
    public boolean enableBricks = true;
    @Config(flag="stone_chiseled")
    public boolean enableChiseledBricks = true;
    @Config(flag="stone_pillar")
    public boolean enablePillar = true;

    @Override
    public void construct() {
        MoreStoneVariantsModule.expandVanillaStone(this, Blocks.f_152497_, "calcite");
        MoreStoneVariantsModule.expandVanillaStone(this, Blocks.f_152537_, "dripstone");
        MoreStoneVariantsModule.expandVanillaStone(this, Blocks.f_152496_, "tuff");
        BooleanSupplier _true = () -> true;
        this.add("granite", MaterialColor.f_76408_, SoundType.f_56742_, _true);
        this.add("diorite", MaterialColor.f_76412_, SoundType.f_56742_, _true);
        this.add("andesite", MaterialColor.f_76409_, SoundType.f_56742_, _true);
        this.add("calcite", MaterialColor.f_76372_, SoundType.f_154660_, _true);
        this.add("dripstone", MaterialColor.f_76384_, SoundType.f_154661_, _true);
        this.add("tuff", MaterialColor.f_76379_, SoundType.f_154659_, _true);
        this.add("limestone", MaterialColor.f_76409_, SoundType.f_56742_, () -> NewStoneTypesModule.enabledWithLimestone);
        this.add("jasper", MaterialColor.f_76386_, SoundType.f_56742_, () -> NewStoneTypesModule.enabledWithJasper);
        this.add("shale", MaterialColor.f_76403_, SoundType.f_56742_, () -> NewStoneTypesModule.enabledWithShale);
        this.add("myalite", MaterialColor.f_76422_, SoundType.f_56742_, () -> NewStoneTypesModule.enabledWithMyalite, MyaliteBlock::new, MyalitePillarBlock::new);
    }

    public static void expandVanillaStone(QuarkModule module, Block raw, String name) {
        NewStoneTypesModule.makeStone(module, raw, name, null, null, () -> true, null, QuarkBlock::new);
    }

    @Override
    public void pushFlags(ConfigFlagManager manager) {
        manager.putFlag(this, "granite", true);
        manager.putFlag(this, "diorite", true);
        manager.putFlag(this, "andesite", true);
        manager.putFlag(this, "calcite", true);
        manager.putFlag(this, "dripstone", true);
        manager.putFlag(this, "tuff", true);
    }

    private void add(String name, MaterialColor color, SoundType sound, BooleanSupplier cond) {
        this.add(name, color, sound, cond, QuarkBlock::new, QuarkPillarBlock::new);
    }

    private void add(String name, MaterialColor color, SoundType sound, BooleanSupplier cond, QuarkBlock.Constructor<QuarkBlock> constr, QuarkBlock.Constructor<QuarkPillarBlock> pillarConstr) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color).m_60999_().m_60918_(sound).m_60913_(1.5f, 6.0f);
        QuarkBlock bricks = constr.make(name + "_bricks", this, CreativeModeTab.f_40749_, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks);
        VariantHandler.addSlabStairsWall(bricks);
        constr.make("chiseled_" + name + "_bricks", this, CreativeModeTab.f_40749_, props).setCondition(() -> cond.getAsBoolean() && this.enableBricks && this.enableChiseledBricks);
        pillarConstr.make(name + "_pillar", this, CreativeModeTab.f_40749_, props).setCondition(() -> cond.getAsBoolean() && this.enablePillar);
    }
}

