/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.RopeBlock;

@LoadModule(category=ModuleCategory.BUILDING)
public class RopeModule
extends QuarkModule {
    public static Block rope;
    @Config(description="Set to true to allow ropes to move Tile Entities even if Pistons Push TEs is disabled.\nNote that ropes will still use the same blacklist.")
    public static boolean forceEnableMoveTileEntities;
    @Config
    public static boolean enableDispenserBehavior;

    @Override
    public void construct() {
        rope = new RopeBlock("rope", this, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76362_).m_60978_(0.5f).m_60918_(SoundType.f_56745_));
    }

    @Override
    public void configChanged() {
        if (enableDispenserBehavior) {
            DispenserBlock.f_52661_.put(rope.m_5456_(), new BehaviourRope());
        } else {
            DispenserBlock.f_52661_.remove(rope.m_5456_());
        }
    }

    static {
        forceEnableMoveTileEntities = false;
        enableDispenserBehavior = true;
    }

    public static class BehaviourRope
    extends OptionalDispenseItemBehavior {
        @Nonnull
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_142300_(facing);
            ServerLevel world = source.m_7727_();
            this.m_123573_(false);
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == rope) {
                if (((RopeBlock)rope).pullDown((Level)world, pos)) {
                    this.m_123573_(true);
                    stack.m_41774_(1);
                    return stack;
                }
            } else if (world.m_46859_(pos) && rope.m_49966_().m_60710_((LevelReader)world, pos)) {
                SoundType soundtype = rope.getSoundType(state, (LevelReader)world, pos, null);
                world.m_46597_(pos, rope.m_49966_());
                world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                this.m_123573_(true);
                stack.m_41774_(1);
                return stack;
            }
            return stack;
        }
    }
}

