/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.structures.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.StructureBlockReplacementHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.VariantChestBlock;
import vazkii.quark.content.building.block.VariantTrappedChestBlock;
import vazkii.quark.content.building.block.be.VariantChestBlockEntity;
import vazkii.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import vazkii.quark.content.building.client.render.be.VariantChestRenderer;
import vazkii.quark.content.building.recipe.MixedExclusionRecipe;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class VariantChestsModule
extends QuarkModule {
    private static final Pattern VILLAGE_PIECE_PATTERN = Pattern.compile("\\w+\\[\\w+\\[([a-z_]+)\\:village\\/(.+?)\\/.+\\]\\]");
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ImmutableSet<String> OVERWORLD_WOODS = ImmutableSet.copyOf((Object[])MiscUtil.OVERWORLD_WOOD_TYPES);
    private static final ImmutableSet<String> NETHER_WOODS = ImmutableSet.copyOf((Object[])MiscUtil.NETHER_WOOD_TYPES);
    private static final ImmutableSet<String> MOD_WOODS = ImmutableSet.of();
    public static BlockEntityType<VariantChestBlockEntity> chestTEType;
    public static BlockEntityType<VariantTrappedChestBlockEntity> trappedChestTEType;
    private static List<Supplier<Block>> chestTypes;
    private static List<Supplier<Block>> trappedChestTypes;
    private static List<Block> allChests;
    private static Map<String, Block> chestMappings;
    @Config
    private static boolean replaceWorldgenChests;
    @Config(flag="chest_reversion")
    private static boolean enableRevertingWoodenChests;
    private static boolean staticEnabled;
    @Config(description="Chests to put in each structure. The format per entry is \"structure=chest\", where \"structure\" is a structure ID, and \"chest\" is a block ID, which must correspond to a standard chest block.")
    public static List<String> structureChests;
    private static final List<String> BUILT_IN_MOD_STRUCTURES;
    private static final Method CHEST_EQUIP;
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @Override
    public void construct() {
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)MixedExclusionRecipe.SERIALIZER);
        OVERWORLD_WOODS.forEach(s -> this.addChest((String)s, Blocks.f_50087_));
        NETHER_WOODS.forEach(s -> this.addChest((String)s, Blocks.f_50087_));
        MOD_WOODS.forEach(s -> this.addModChest((String)s, Blocks.f_50087_));
        this.addChest("nether_brick", Blocks.f_50197_);
        this.addChest("purpur", Blocks.f_50492_);
        this.addChest("prismarine", Blocks.f_50377_);
        StructureBlockReplacementHandler.functions.add(VariantChestsModule::getGenerationChestBlockState);
    }

    @Override
    public void modulesStarted() {
        chestTEType = VariantChestsModule.registerChests(VariantChestBlockEntity::new, chestTypes);
        trappedChestTEType = VariantChestsModule.registerChests(VariantTrappedChestBlockEntity::new, trappedChestTypes);
        RegistryHelper.register(chestTEType, (String)"variant_chest");
        RegistryHelper.register(trappedChestTEType, (String)"variant_trapped_chest");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        BlockEntityRenderers.m_173590_(chestTEType, VariantChestRenderer::new);
        BlockEntityRenderers.m_173590_(trappedChestTEType, VariantChestRenderer::new);
    }

    @Override
    public void configChanged() {
        super.configChanged();
        staticEnabled = this.enabled;
        chestMappings.clear();
        ArrayList<String> chestsClone = new ArrayList<String>(BUILT_IN_MOD_STRUCTURES);
        chestsClone.addAll(structureChests);
        for (String s : chestsClone) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String left = toks[0];
            String right = toks[1];
            Registry.f_122824_.m_6612_(new ResourceLocation(right)).ifPresent(block -> {
                if (block != Blocks.f_50016_) {
                    chestMappings.put(left, (Block)block);
                }
            });
        }
    }

    private static BlockState getGenerationChestBlockState(BlockState current, StructureBlockReplacementHandler.StructureHolder structure) {
        if (staticEnabled && replaceWorldgenChests && current.m_60734_() == Blocks.f_50087_) {
            Block block;
            BlockState placeState;
            LegacySinglePoolElement legacyJigsaw;
            String type;
            Matcher match;
            PoolElementStructurePiece avp;
            StructurePoolElement jigsaw;
            StructurePiece first;
            ResourceLocation res = structure.currentStructure.getRegistryName();
            if (res == null) {
                return null;
            }
            Object name = res.toString();
            if ("minecraft:village".equals(name) && structure.currentComponents != null && structure.currentComponents.size() > 0 && (first = structure.currentComponents.get(0)) instanceof PoolElementStructurePiece && (jigsaw = (avp = (PoolElementStructurePiece)first).m_72645_()) instanceof LegacySinglePoolElement && (match = VILLAGE_PIECE_PATTERN.matcher(type = (legacyJigsaw = (LegacySinglePoolElement)jigsaw).toString())).matches()) {
                String namespace = match.group(1);
                String villageType = match.group(2);
                name = (String)name + "_" + villageType;
                if (!namespace.equals("minecraft")) {
                    name = ((String)name).replace("minecraft\\:", namespace);
                }
            }
            if (chestMappings.containsKey(name) && (placeState = (block = chestMappings.get(name)).m_49966_()).m_61147_().contains(ChestBlock.f_51479_)) {
                placeState = (BlockState)((BlockState)((BlockState)placeState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)((Direction)current.m_61143_((Property)ChestBlock.f_51478_)))).m_61124_((Property)ChestBlock.f_51479_, (Comparable)((ChestType)current.m_61143_((Property)ChestBlock.f_51479_)))).m_61124_((Property)ChestBlock.f_51480_, (Comparable)((Boolean)current.m_61143_((Property)ChestBlock.f_51480_)));
                return placeState;
            }
        }
        return null;
    }

    void addChest(String name, Block from) {
        this.addChest(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
    }

    public void addChest(String name, BlockBehaviour.Properties props) {
        VariantChestsModule.addChest(name, this, props, false);
    }

    public static void addChest(String name, QuarkModule module, BlockBehaviour.Properties props, boolean external) {
        BooleanSupplier cond = external ? () -> ModuleLoader.INSTANCE.isModuleEnabled(VariantChestsModule.class) : () -> true;
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock(name, module, (Supplier<BlockEntityType<? extends ChestBlockEntity>>)((Supplier)() -> chestTEType), props).setCondition(cond)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock(name, module, (Supplier<BlockEntityType<? extends ChestBlockEntity>>)((Supplier)() -> trappedChestTEType), props).setCondition(cond)));
    }

    private void addModChest(String nameRaw, Block from) {
        String[] toks = nameRaw.split(":");
        String name = toks[1];
        String mod = toks[0];
        this.addModChest(name, mod, BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
    }

    private void addModChest(String name, String mod, BlockBehaviour.Properties props) {
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock.Compat(name, mod, this, (Supplier<BlockEntityType<? extends ChestBlockEntity>>)((Supplier)() -> chestTEType), props)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock.Compat(name, mod, this, (Supplier<BlockEntityType<? extends ChestBlockEntity>>)((Supplier)() -> trappedChestTEType), props)));
    }

    public static <T extends BlockEntity> BlockEntityType<T> registerChests(BlockEntityType.BlockEntitySupplier<? extends T> factory, List<Supplier<Block>> list) {
        List<Block> blockTypes = list.stream().map(Supplier::get).collect(Collectors.toList());
        allChests.addAll(blockTypes);
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blockTypes.toArray(new Block[blockTypes.size()])).m_58966_(null);
    }

    @Override
    public void textureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().toString().equals("minecraft:textures/atlas/chest.png")) {
            for (Block b : allChests) {
                VariantChestRenderer.accept(event, b);
            }
        }
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestedHorse horse;
        Entity target = event.getTarget();
        Player player = event.getPlayer();
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_41619_() && target instanceof AbstractChestedHorse && !(horse = (AbstractChestedHorse)target).m_30502_() && held.m_41720_() != Items.f_42009_ && held.m_150922_((Tag)Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!target.f_19853_.f_46443_) {
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                held.m_41774_(1);
                horse.getPersistentData().m_128365_(DONK_CHEST, (net.minecraft.nbt.Tag)copy.serializeNBT());
                horse.m_30504_(true);
                horse.m_30625_();
                try {
                    CHEST_EQUIP.invoke((Object)horse, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Quark.LOG.error("Failed to play chest equip sound", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestedHorse horse;
        ItemStack chest;
        LivingEntity target = event.getEntityLiving();
        if (target instanceof AbstractChestedHorse && !(chest = ItemStack.m_41712_((CompoundTag)(horse = (AbstractChestedHorse)target).getPersistentData().m_128469_(DONK_CHEST))).m_41619_() && horse.m_30502_()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && ((ItemEntity)target).m_32055_().m_41720_() == Items.f_42009_) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.m_41619_()) {
                ((ItemEntity)target).m_32045_(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        chestTypes = new LinkedList<Supplier<Block>>();
        trappedChestTypes = new LinkedList<Supplier<Block>>();
        allChests = new LinkedList<Block>();
        chestMappings = new HashMap<String, Block>();
        replaceWorldgenChests = true;
        enableRevertingWoodenChests = true;
        staticEnabled = false;
        structureChests = Arrays.asList("minecraft:village_plains=quark:oak_chest", "minecraft:igloo=quark:spruce_chest", "minecraft:village_snowy=quark:spruce_chest", "minecraft:village_taiga=quark:spruce_chest", "minecraft:desert_pyramid=quark:birch_chest", "minecraft:jungle_pyramid=quark:jungle_chest", "minecraft:village_desert=quark:jungle_chest", "minecraft:village_savanna=quark:acacia_chest", "minecraft:mansion=quark:dark_oak_chest", "minecraft:pillager_outpost=quark:dark_oak_chest", "minecraft:ruined_portal=quark:crimson_chest", "minecraft:bastion_remnant=quark:crimson_chest", "minecraft:fortress=quark:nether_brick_chest", "minecraft:endcity=quark:purpur_chest");
        BUILT_IN_MOD_STRUCTURES = Arrays.asList("bettermineshafts:mineshaft=quark:oak_chest", "betterstrongholds:stronghold=quark:oak_chest", "cobbler:shulker_factory=quark:purpur_chest", "conjurer_illager:theatre=quark:dark_oak_chest", "dungeoncrawl:dungeon=quark:oak_chest", "dungeons_plus:bigger_dungeon=quark:oak_chest", "dungeons_plus:end_ruins=quark:purpur_chest", "dungeons_plus:leviathan=quark:jungle_chest", "dungeons_plus:snowy_temple=quark:spruce_chest", "dungeons_plus:soul_prison=quark:warped_chest", "dungeons_plus:tower=quark:oak_chest", "dungeons_plus:warped_garden=quark:warped_chest", "hunterillager:hunterhouse=quark:spruce_chest", "iceandfire:gorgon_temple=quark:jungle_chest", "illagers_plus:illager_archer_tower=quark:dark_oak_chest", "illagers_plus:illager_centre=quark:dark_oak_chest", "illagers_plus:illager_fort=quark:dark_oak_chest", "illagers_plus:illager_tower=quark:dark_oak_chest", "infernalexp:bastion_outpost=quark:crimson_chest", "infernalexp:glowstone_canyon_ruin=quark:crimson_chest", "infernalexp:strider_altar=quark:crimson_chest", "pandoras_creatures:end_prison=quark:purpur_chest", "mowziesmobs:barakoa_village=quark:acacia_chest", "endreborn:end_crypt=quark:purpur_chest", "endreborn:end_shipwreck=quark:purpur_chest", "majruszs_difficulty:flying_end_ship=quark:purpur_chest", "majruszs_difficulty:flying_phantom_structure=quark:purpur_chest", "outer_end:catacombs=quark:purpur_chest", "outer_end:end_tower=quark:purpur_chest", "stoneholm:underground_village=quark:spruce_chest", "repurposed_structures:bastion_underground=quark:dark_oak_chest", "repurposed_structures:city_nether=quark:nether_brick_chest", "repurposed_structures:fortress_jungle=quark:jungle_chest", "repurposed_structures:igloo_grassy=quark:oak_chest", "repurposed_structures:igloo_stone=quark:spruce_chest", "repurposed_structures:mansion_birch=quark:birch_chest", "repurposed_structures:mansion_desert=quark:jungle_chest", "repurposed_structures:mansion_jungle=quark:jungle_chest", "repurposed_structures:mansion_oak=quark:oak_chest", "repurposed_structures:mansion_savanna=quark:acacia_chest", "repurposed_structures:mansion_snowy=quark:spruce_chest", "repurposed_structures:mansion_taiga=quark:spruce_chest", "repurposed_structures:mineshaft_birch=quark:birch_chest", "repurposed_structures:mineshaft_crimson=quark:crimson_chest", "repurposed_structures:mineshaft_desert=quark:jungle_chest", "repurposed_structures:mineshaft_end=quark:purpur_chest", "repurposed_structures:mineshaft_icy=quark:spruce_chest", "repurposed_structures:mineshaft_jungle=quark:jungle_chest", "repurposed_structures:mineshaft_nether=quark:nether_brick_chest", "repurposed_structures:mineshaft_ocean=quark:prismarine_chest", "repurposed_structures:mineshaft_savanna=quark:acacia_chest", "repurposed_structures:mineshaft_stone=quark:spruce_chest", "repurposed_structures:mineshaft_swamp=quark:dark_oak_chest", "repurposed_structures:mineshaft_dark_forest=quark:dark_oak_chest", "repurposed_structures:mineshaft_taiga=quark:spruce_chest", "repurposed_structures:mineshaft_warped=quark:warped_chest", "repurposed_structures:outpost_badlands=quark:dark_oak_chest", "repurposed_structures:outpost_birch=quark:birch_chest", "repurposed_structures:outpost_crimson=quark:crimson_chest", "repurposed_structures:outpost_desert=quark:jungle_chest", "repurposed_structures:outpost_giant_tree_taiga=quark:spruce_chest", "repurposed_structures:outpost_icy=quark:spruce_chest", "repurposed_structures:outpost_jungle=quark:jungle_chest", "repurposed_structures:outpost_nether_brick=quark:nether_brick_chest", "repurposed_structures:outpost_oak=quark:oak_chest", "repurposed_structures:outpost_snowy=quark:spruce_chest", "repurposed_structures:outpost_taiga=quark:spruce_chest", "repurposed_structures:outpost_warped=quark:warped_chest", "repurposed_structures:pyramid_badlands=quark:dark_oak_trapped_chest", "repurposed_structures:pyramid_end=quark:purpur_chest", "repurposed_structures:pyramid_flower_forest=quark:oak_chest", "repurposed_structures:pyramid_giant_tree_taiga=quark:spruce_chest", "repurposed_structures:pyramid_icy=quark:spruce_chest", "repurposed_structures:pyramid_jungle=quark:jungle_chest", "repurposed_structures:pyramid_nether=quark:nether_brick_trapped_chest", "repurposed_structures:pyramid_ocean=quark:prismarine_chest", "repurposed_structures:pyramid_snowy=quark:spruce_chest", "repurposed_structures:ruined_portal_end=quark:purpur_chest", "repurposed_structures:ruins_land_hot=quark:jungle_chest", "repurposed_structures:ruins_land_warm=quark:oak_chest", "repurposed_structures:ruins_nether=quark:nether_brick_chest", "repurposed_structures:shipwreck_crimson=quark:crimson_chest", "repurposed_structures:shipwreck_end=quark:purpur_chest", "repurposed_structures:shipwreck_nether_bricks=quark:nether_brick_chest", "repurposed_structures:shipwreck_warped=quark:warped_chest", "repurposed_structures:stronghold_nether=quark:nether_brick_chest", "repurposed_structures:temple_nether_basalt=quark:nether_brick_chest", "repurposed_structures:temple_nether_crimson=quark:crimson_chest", "repurposed_structures:temple_nether_soul=quark:warped_chest", "repurposed_structures:temple_nether_warped=quark:warped_trapped_chest", "repurposed_structures:temple_nether_wasteland=quark:nether_brick_chest", "repurposed_structures:village_badlands=quark:dark_oak_chest", "repurposed_structures:village_birch=quark:birch_chest", "repurposed_structures:village_crimson=quark:crimson_chest", "repurposed_structures:village_dark_oak=quark:dark_oak_chest", "repurposed_structures:village_giant_taiga=quark:spruce_chest", "repurposed_structures:village_jungle=quark:jungle_chest", "repurposed_structures:village_mountains=quark:spruce_chest", "repurposed_structures:village_oak=quark:oak_chest", "repurposed_structures:village_swamp=quark:oak_chest", "repurposed_structures:village_warped=quark:warped_chest", "valhelsia_structures:big_tree=quark:oak_chest", "valhelsia_structures:castle=quark:spruce_chest", "valhelsia_structures:castle_ruin=quark:oak_chest", "valhelsia_structures:desert_house=quark:spruce_chest", "valhelsia_structures:forge=quark:spruce_chest", "valhelsia_structures:player_house=quark:oak_chest", "valhelsia_structures:small_castle=quark:oak_chest", "valhelsia_structures:small_dungeon=quark:oak_chest", "valhelsia_structures:spawner_dungeon=quark:oak_chest", "valhelsia_structures:tower_ruin=quark:spruce_chest", "valhelsia_structures:witch_hut=quark:spruce_chest");
        CHEST_EQUIP = ObfuscationReflectionHelper.findMethod(AbstractChestedHorse.class, (String)"m_7609_", (Class[])new Class[0]);
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    public static interface IChestTextureProvider {
        public String getChestTexturePath();

        public boolean isTrap();
    }
}

