/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.ItemOverrideHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.VariantLadderBlock;

@LoadModule(category=ModuleCategory.BUILDING)
public class VariantLaddersModule
extends QuarkModule {
    @Config
    public static boolean changeNames = true;
    public static List<Block> variantLadders = new LinkedList<Block>();
    public static boolean moduleEnabled;

    @Override
    public void construct() {
        for (String type : MiscUtil.OVERWORLD_VARIANT_WOOD_TYPES) {
            variantLadders.add((Block)new VariantLadderBlock(type, this, true));
        }
        for (String type : MiscUtil.NETHER_WOOD_TYPES) {
            variantLadders.add((Block)new VariantLadderBlock(type, this, false));
        }
    }

    @Override
    public void loadComplete() {
        variantLadders.forEach(FuelHandler::addWood);
    }

    @Override
    public void configChanged() {
        moduleEnabled = this.enabled;
        ItemOverrideHandler.changeBlockLocalizationKey(Blocks.f_50155_, "block.quark.oak_ladder", changeNames && this.enabled);
    }

    public static boolean isTrapdoorLadder(boolean defaultValue, LevelReader world, BlockPos pos) {
        BlockState down;
        if (defaultValue || !moduleEnabled) {
            return defaultValue;
        }
        BlockState curr = world.m_8055_(pos);
        if (curr.m_61147_().contains(TrapDoorBlock.f_57514_) && ((Boolean)curr.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue() && (down = world.m_8055_(pos.m_7495_())).m_60734_() instanceof LadderBlock) {
            return down.m_61143_((Property)LadderBlock.f_54337_) == curr.m_61143_((Property)TrapDoorBlock.f_54117_);
        }
        return false;
    }
}

