/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.MANAGEMENT)
public class ExpandedItemInteractionsModule
extends QuarkModule {
    @Config
    public static boolean enableArmorInteraction = true;
    @Config
    public static boolean enableShulkerBoxInteraction = true;
    @Config
    public static boolean enableLavaInteraction = true;
    private static boolean staticEnabled = false;

    @Override
    public void configChanged() {
        staticEnabled = this.configEnabled;
    }

    public static boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        ItemStack stackAt = slot.m_7993_();
        if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, stackAt, slot, action, player, false)) {
            if (player.f_36096_ != null) {
                player.f_36096_.m_6199_(slot.f_40218_);
            }
            return true;
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        if (enableLavaInteraction && ExpandedItemInteractionsModule.lavaBucketOverride(stack, incoming, slot, action, player)) {
            return true;
        }
        if (enableArmorInteraction && ExpandedItemInteractionsModule.armorOverride(stack, incoming, slot, action, player)) {
            return true;
        }
        return enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, incoming, slot, action, player, true);
    }

    private static boolean armorOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player) {
        if (incoming.m_41619_()) {
            EquipmentSlot equipSlot = null;
            if (stack.m_41720_() instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)stack.m_41720_();
                equipSlot = armor.m_40402_();
            } else if (stack.m_41720_() instanceof ElytraItem) {
                equipSlot = EquipmentSlot.CHEST;
            }
            if (equipSlot != null) {
                int index;
                ItemStack currArmor = player.m_6844_(equipSlot);
                if (slot.m_8010_(player) && slot.m_5857_(currArmor) && (currArmor.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44975_, (ItemStack)currArmor) == 0 && currArmor != stack) && (index = slot.getSlotIndex()) < slot.f_40218_.m_6643_()) {
                    player.m_8061_(equipSlot, stack.m_41777_());
                    slot.f_40218_.m_6836_(index, currArmor.m_41777_());
                    slot.m_40234_(stack, currArmor);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean lavaBucketOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player) {
        if (stack.m_41720_() == Items.f_42448_ && !incoming.m_41619_() && !player.m_7500_() && slot.m_150651_(player) && slot.m_5857_(stack) && !incoming.m_41720_().m_41475_() && !SimilarBlockTypeHandler.isShulkerBox(incoming)) {
            incoming.m_41764_(0);
            if (!player.f_19853_.f_46443_) {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 0.25f, 2.0f + (float)Math.random());
            }
            return true;
        }
        return false;
    }

    private static boolean shulkerOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean setSlot) {
        ItemStack finished;
        if (!incoming.m_41619_() && ExpandedItemInteractionsModule.tryAddToShulkerBox(player, stack, incoming, slot, true, setSlot) != null && (finished = ExpandedItemInteractionsModule.tryAddToShulkerBox(player, stack, incoming, slot, false, setSlot)) != null) {
            if (setSlot) {
                slot.m_5852_(finished);
            }
            return true;
        }
        return false;
    }

    private static ItemStack tryAddToShulkerBox(Player player, ItemStack shulkerBox, ItemStack stack, Slot slot, boolean simulate, boolean useCopy) {
        if (!SimilarBlockTypeHandler.isShulkerBox(shulkerBox) || !slot.m_8010_(player)) {
            return null;
        }
        CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)shulkerBox, (String)"BlockEntityTag", (boolean)false);
        if (cmp.m_128441_("LootTable")) {
            return null;
        }
        if (cmp != null) {
            LazyOptional handlerHolder;
            BlockEntity te = null;
            cmp = cmp.m_6426_();
            cmp.m_128359_("id", "minecraft:shulker_box");
            if (shulkerBox.m_41720_() instanceof BlockItem) {
                Block shulkerBoxBlock = Block.m_49814_((Item)shulkerBox.m_41720_());
                BlockState defaultState = shulkerBoxBlock.m_49966_();
                if (shulkerBoxBlock instanceof EntityBlock) {
                    te = ((EntityBlock)shulkerBoxBlock).m_142194_(BlockPos.f_121853_, defaultState);
                    te.m_142466_(cmp);
                }
            }
            if (te != null && (handlerHolder = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).isPresent()) {
                boolean did;
                IItemHandler handler = (IItemHandler)handlerHolder.orElseGet(EmptyHandler::new);
                ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate);
                boolean bl = did = result.m_41619_() || result.m_41613_() != stack.m_41613_();
                if (did) {
                    ItemStack workStack;
                    ItemStack itemStack = workStack = useCopy ? shulkerBox.m_41777_() : shulkerBox;
                    if (!simulate) {
                        stack.m_41764_(result.m_41613_());
                    }
                    cmp = te.m_187480_();
                    ItemNBTHelper.setCompound((ItemStack)workStack, (String)"BlockEntityTag", (CompoundTag)cmp);
                    if (slot.m_5857_(workStack)) {
                        return workStack;
                    }
                }
            }
        }
        return null;
    }
}

