/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.LinkItemMessage;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ItemSharingModule
extends QuarkModule {
    @Config
    public static boolean renderItemsInChat = true;
    private static int chatX;
    private static int chatY;
    public static float alphaValue;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keyboardEvent(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Options settings = mc.f_91066_;
        Screen screen = event.getScreen();
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)settings.f_92098_.getKey().m_84873_()) && screen instanceof AbstractContainerScreen && Screen.m_96638_()) {
            ItemStack stack;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            List children = gui.m_6702_();
            for (GuiEventListener c : children) {
                EditBox tf;
                if (!(c instanceof EditBox) || !(tf = (EditBox)c).m_93696_()) continue;
                return;
            }
            Slot slot = gui.getSlotUnderMouse();
            if (slot != null && slot.f_40218_ != null && !(stack = slot.m_7993_()).m_41619_() && !MinecraftForge.EVENT_BUS.post((Event)new ClientChatEvent(stack.m_41611_().getString()))) {
                QuarkNetwork.sendToServer(new LinkItemMessage(stack));
                event.setCanceled(true);
            }
        }
    }

    public static void linkItem(Player player, ItemStack item) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class)) {
            return;
        }
        if (!item.m_41619_() && player instanceof ServerPlayer) {
            Component comp = item.m_41611_();
            TranslatableComponent fullComp = new TranslatableComponent("chat.type.text", new Object[]{player.m_5446_(), comp});
            PlayerList players = ((ServerPlayer)player).f_8924_.m_6846_();
            ServerChatEvent event = new ServerChatEvent((ServerPlayer)player, comp.getString(), (Component)fullComp);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                players.m_11264_(event.getComponent(), ChatType.CHAT, player.m_142081_());
                ServerGamePacketListenerImpl handler = ((ServerPlayer)player).f_8906_;
                int threshold = handler.f_9750_;
                if ((threshold += 20) > 200 && !players.m_11303_(player.m_36316_())) {
                    handler.m_7026_((Component)new TranslatableComponent("disconnect.spam"));
                }
                handler.f_9750_ = threshold;
            }
        }
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return component;
        }
        Style style = component.m_7383_();
        if (stack.m_41613_() > 64) {
            ItemStack copyStack = stack.m_41777_();
            copyStack.m_41764_(64);
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.m_130948_(style);
        }
        TextComponent out = new TextComponent("   ");
        out.m_6270_(style);
        return out.m_7220_((Component)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void getChatPos(RenderGameOverlayEvent.Chat event) {
        chatX = event.getPosX();
        chatY = event.getPosY();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderSymbols(RenderGameOverlayEvent.Post event) {
        if (!renderItemsInChat) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Gui gameGui = mc.f_91065_;
        ChatComponent chatGui = gameGui.m_93076_();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            int shift;
            int updateCounter = gameGui.m_93079_();
            List lines = chatGui.f_93761_;
            int idx = shift = chatGui.f_93763_;
            while (idx < lines.size() && idx - shift < chatGui.m_93816_()) {
                GuiMessage line = (GuiMessage)lines.get(idx);
                StringBuilder before = new StringBuilder();
                FormattedCharSequence lineProperties = (FormattedCharSequence)line.m_90793_();
                int captureIndex = idx++;
                lineProperties.m_13731_((counter_, style, character) -> {
                    String sofar = before.toString();
                    if (sofar.endsWith("    ")) {
                        ItemSharingModule.render(mc, event.getMatrixStack(), chatGui, updateCounter, sofar.substring(0, sofar.length() - 3), (GuiMessage<FormattedCharSequence>)line, captureIndex - shift, style);
                        return false;
                    }
                    before.append((char)character);
                    return true;
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, PoseStack pose, ChatComponent chatGui, int updateCounter, String before, GuiMessage<FormattedCharSequence> line, int lineHeight, Style style) {
        HoverEvent hoverEvent = style.m_131186_();
        if (hoverEvent != null && hoverEvent.m_130820_() == HoverEvent.Action.f_130832_) {
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
            ItemStack itemStack = stack = contents != null ? contents.m_130898_() : ItemStack.f_41583_;
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Blocks.f_50375_);
            }
            int timeSinceCreation = updateCounter - line.m_90794_();
            if (chatGui.m_93818_()) {
                timeSinceCreation = 0;
            }
            if (timeSinceCreation < 200) {
                float chatOpacity = (float)mc.f_91066_.f_92120_ * 0.9f + 0.1f;
                float fadeOut = Mth.m_14036_((float)((1.0f - (float)timeSinceCreation / 200.0f) * 10.0f), (float)0.0f, (float)1.0f);
                float alpha = fadeOut * fadeOut * chatOpacity;
                int x = chatX + 3 + mc.f_91062_.m_92895_(before);
                Objects.requireNonNull(mc.f_91062_);
                int y = chatY - 9 * lineHeight;
                if (alpha > 0.0f) {
                    alphaValue = alpha;
                    PoseStack modelviewPose = RenderSystem.m_157191_();
                    modelviewPose.m_85836_();
                    modelviewPose.m_85837_((double)(x - 2), (double)(y - 2), 0.0);
                    modelviewPose.m_85841_(0.65f, 0.65f, 0.65f);
                    mc.m_91291_().m_115123_(stack, 0, 0);
                    modelviewPose.m_85849_();
                    RenderSystem.m_157182_();
                    alphaValue = 1.0f;
                }
            }
        }
    }

    static {
        alphaValue = 1.0f;
    }
}

