/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.SetTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FavorBlockGoal
extends Goal {
    private final PathfinderMob creature;
    private final double movementSpeed;
    private final Predicate<BlockState> targetBlock;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.f_121853_;

    public FavorBlockGoal(PathfinderMob creature, double speed, Predicate<BlockState> predicate) {
        this.creature = creature;
        this.movementSpeed = speed;
        this.targetBlock = predicate;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public FavorBlockGoal(PathfinderMob creature, double speed, SetTag<Block> tag) {
        this(creature, speed, (BlockState state) -> tag.m_8110_((Object)state.m_60734_()));
    }

    public FavorBlockGoal(PathfinderMob creature, double speed, Block block) {
        this(creature, speed, (BlockState state) -> state.m_60734_() == block);
    }

    public boolean m_8036_() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.creature.m_21187_().nextInt(200);
        return this.searchForDestination();
    }

    public boolean m_8045_() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.targetBlock.test(this.creature.f_19853_.m_8055_(this.destinationBlock));
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_((double)this.destinationBlock.m_123341_() + 0.5, (double)(this.destinationBlock.m_123342_() + 1), (double)this.destinationBlock.m_123343_() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.m_21187_().nextInt(this.creature.m_21187_().nextInt(1200) + 1200) + 1200;
    }

    public void m_8037_() {
        Vec3 vec3 = new Vec3((double)this.destinationBlock.m_123341_(), (double)this.destinationBlock.m_123342_(), (double)this.destinationBlock.m_123343_());
        if (this.creature.m_20238_(vec3.m_82520_(0.5, 1.5, 0.5)) > 1.0) {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.m_21573_().m_26519_((double)this.destinationBlock.m_123341_() + 0.5, (double)(this.destinationBlock.m_123342_() + 1), (double)this.destinationBlock.m_123343_() + 0.5, this.movementSpeed);
            }
        } else {
            --this.timeoutCounter;
        }
    }

    private boolean searchForDestination() {
        double followRange = this.creature.m_21051_(Attributes.f_22277_).m_22135_();
        Vec3 cpos = this.creature.m_20182_();
        double xBase = cpos.f_82479_;
        double yBase = cpos.f_82480_;
        double zBase = cpos.f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int yShift = 0;
        while (yShift <= 1) {
            int seekDist = 0;
            while ((double)seekDist < followRange) {
                int xShift = 0;
                while (xShift <= seekDist) {
                    int zShift;
                    int n = zShift = xShift < seekDist && xShift > -seekDist ? seekDist : 0;
                    while (zShift <= seekDist) {
                        pos.m_122169_(xBase + (double)xShift, yBase + (double)yShift - 1.0, zBase + (double)zShift);
                        if (this.creature.m_21444_((BlockPos)pos) && this.targetBlock.test(this.creature.f_19853_.m_8055_((BlockPos)pos))) {
                            this.destinationBlock = pos;
                            return true;
                        }
                        zShift = zShift > 0 ? -zShift : 1 - zShift;
                    }
                    xShift = xShift > 0 ? -xShift : 1 - xShift;
                }
                ++seekDist;
            }
            yShift = yShift > 0 ? -yShift : 1 - yShift;
        }
        return false;
    }
}

