/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import vazkii.quark.content.mobs.entity.Crab;

public class CrabModel
extends EntityModel<Crab> {
    private float wiggleX = 0.0f;
    private float wiggleY = 0.0f;
    private float crabSize = 0.0f;
    public ModelPart group;
    public ModelPart body;
    public ModelPart rightClaw;
    public ModelPart leftClaw;
    public ModelPart rightLeg1;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart rightLeg4;
    public ModelPart leftLeg1;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart leftLeg4;
    public ModelPart rightEye;
    public ModelPart leftEye;
    private final Set<ModelPart> leftLegs;
    private final Set<ModelPart> rightLegs;

    public CrabModel(ModelPart root) {
        this.group = root.m_171324_("group");
        this.body = this.group.m_171324_("body");
        this.rightClaw = this.group.m_171324_("rightClaw");
        this.leftClaw = this.group.m_171324_("leftClaw");
        this.rightLeg1 = this.group.m_171324_("rightLeg1");
        this.rightLeg2 = this.group.m_171324_("rightLeg2");
        this.rightLeg3 = this.group.m_171324_("rightLeg3");
        this.rightLeg4 = this.group.m_171324_("rightLeg4");
        this.leftLeg1 = this.group.m_171324_("leftLeg1");
        this.leftLeg2 = this.group.m_171324_("leftLeg2");
        this.leftLeg3 = this.group.m_171324_("leftLeg3");
        this.leftLeg4 = this.group.m_171324_("leftLeg4");
        this.rightEye = this.body.m_171324_("rightEye");
        this.leftEye = this.body.m_171324_("leftEye");
        this.leftLegs = ImmutableSet.of((Object)this.leftLeg1, (Object)this.leftLeg2, (Object)this.leftLeg3, (Object)this.leftLeg4);
        this.rightLegs = ImmutableSet.of((Object)this.rightLeg1, (Object)this.rightLeg2, (Object)this.rightLeg3, (Object)this.rightLeg4);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition group = root.m_171599_("group", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition body = group.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -2.5f, -3.0f, 8.0f, 5.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        group.m_171599_("leftLeg4", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 19).m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)0.43633232f, (float)0.7853982f));
        group.m_171599_("leftLeg3", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 19).m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.21816616f, (float)0.7853982f));
        body.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-3.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        group.m_171599_("rightLeg4", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)-0.43633232f, (float)-0.7853982f));
        group.m_171599_("rightClaw", CubeListBuilder.m_171558_().m_171514_(14, 11).m_171481_(-3.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)0.3926991f, (float)-0.3926991f));
        group.m_171599_("leftLeg1", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 19).m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)2.0f, (float)0.0f, (float)-0.43633232f, (float)0.7853982f));
        group.m_171599_("rightLeg2", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 19).m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)0.9f, (float)0.0f, (float)0.21816616f, (float)-0.7853982f));
        group.m_171599_("leftClaw", CubeListBuilder.m_171558_().m_171480_().m_171514_(14, 11).m_171481_(0.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)-0.3926991f, (float)0.3926991f));
        group.m_171599_("rightLeg1", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)2.0f, (float)0.0f, (float)0.43633232f, (float)-0.7853982f));
        body.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(2.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        group.m_171599_("leftLeg2", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 19).m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)0.9f, (float)0.0f, (float)-0.21816616f, (float)0.7853982f));
        group.m_171599_("rightLeg3", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)-0.21816616f, (float)-0.7853982f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    public void setupAnim(Crab crab, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightLeg1.f_104205_ = -0.2618f + (-1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg2.f_104205_ = -0.5236f + (-1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.rightLeg3.f_104205_ = -0.5236f + (-1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg4.f_104205_ = -0.2618f + (-1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg1.f_104205_ = 0.2618f + (1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg2.f_104205_ = 0.5236f + (1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftLeg3.f_104205_ = 0.5236f + (1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg4.f_104205_ = 0.2618f + (1.0f + Mth.m_14089_((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftClaw.f_104203_ = 0.0f;
        this.rightClaw.f_104203_ = 0.0f;
        this.wiggleX = 0.0f;
        this.wiggleY = 0.0f;
        this.crabSize = crab.getSizeModifier();
        if (this.f_102610_) {
            this.crabSize /= 2.0f;
        }
        if (crab.isRaving()) {
            float armRot;
            float crabRaveBPM = 31.25f;
            float freq = 20.0f / crabRaveBPM;
            float tick = ageInTicks * freq;
            float sin = (float)(Math.sin(tick) * 0.5 + 0.5);
            float legRot = sin * 0.8f + 0.6f;
            this.leftLegs.forEach(l -> {
                l.f_104205_ = legRot;
            });
            this.rightLegs.forEach(l -> {
                l.f_104205_ = -legRot;
            });
            float maxHeight = -0.05f;
            float horizontalOff = 0.2f;
            this.wiggleX = (sin - 0.5f) * 2.0f * maxHeight + maxHeight / 2.0f;
            float slowSin = (float)Math.sin(tick / 2.0f);
            this.wiggleY = slowSin * horizontalOff;
            this.leftClaw.f_104203_ = armRot = sin * 0.5f - 1.2f;
            this.rightClaw.f_104203_ = armRot;
        }
    }

    public void m_7695_(PoseStack matrix, VertexConsumer vb, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, 1.5 - (double)this.crabSize * 1.5, 0.0);
        matrix.m_85841_(this.crabSize, this.crabSize, this.crabSize);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrix.m_85837_((double)this.wiggleX, (double)this.wiggleY, 0.0);
        this.group.m_104306_(matrix, vb, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
        matrix.m_85849_();
    }
}

