/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import vazkii.quark.content.tools.module.BeaconRedirectionModule;

public class QuarkBeaconBlockEntityRenderer {
    public static boolean render(BeaconBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!BeaconRedirectionModule.staticEnabled) {
            return false;
        }
        long i = tileEntityIn.m_58904_().m_46467_();
        List list = tileEntityIn.m_58702_();
        for (int k = 0; k < list.size(); ++k) {
            BeaconBlockEntity.BeaconBeamSection segment = (BeaconBlockEntity.BeaconBeamSection)list.get(k);
            if (!(segment instanceof BeaconRedirectionModule.ExtendedBeamSegment)) {
                return false;
            }
            QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, (BeaconRedirectionModule.ExtendedBeamSegment)segment, partialTicks, i);
        }
        return true;
    }

    private static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, long totalWorldTime) {
        QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, BeaconRenderer.f_112102_, segment, partialTicks, 1.0f, totalWorldTime, 0.2f, 0.25f);
    }

    public static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, ResourceLocation textureLocation, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, float textureScale, long totalWorldTime, float beamRadius, float glowRadius) {
        int height = segment.m_58723_();
        float[] colors = segment.m_58722_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_85837_((double)segment.offset.m_123341_(), (double)segment.offset.m_123342_(), (double)segment.offset.m_123343_());
        matrixStackIn.m_85845_(segment.dir.m_122406_());
        float f = -((float)Math.floorMod(totalWorldTime, 40L) + partialTicks);
        float f2 = Mth.m_14187_((float)(0.2f - (float)Mth.m_14143_((float)(f * 0.1f))));
        float f3 = colors[0];
        float f4 = colors[1];
        float f5 = colors[2];
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -beamRadius;
        float f12 = -beamRadius;
        float f15 = -1.0f + f2;
        float f16 = (float)height * textureScale * (0.5f / beamRadius) + f15;
        QuarkBeaconBlockEntityRenderer.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (boolean)false)), f3, f4, f5, 1.0f, height, 0.0f, beamRadius, beamRadius, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        matrixStackIn.m_85849_();
        f6 = -glowRadius;
        float f7 = -glowRadius;
        f8 = -glowRadius;
        f9 = -glowRadius;
        f15 = -1.0f + f2;
        f16 = (float)height * textureScale + f15;
        QuarkBeaconBlockEntityRenderer.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (boolean)true)), f3, f4, f5, 0.125f, height, f6, f7, glowRadius, f8, f9, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.m_85849_();
    }

    private static void renderPart(PoseStack matrixStackIn, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int height, float p_228840_8_, float p_228840_9_, float p_228840_10_, float p_228840_11_, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float u1, float u2, float v1, float v2) {
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_8_, p_228840_9_, p_228840_10_, p_228840_11_, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_10_, p_228840_11_, p_228840_14_, p_228840_15_, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, p_228840_12_, p_228840_13_, p_228840_8_, p_228840_9_, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.m_85982_(matrixPos, x, (float)y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

