/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.entity;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.entity.Toretoise;
import vazkii.quark.content.tools.module.PickarangModule;

public class Pickarang
extends Projectile {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(Pickarang.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(Pickarang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NETHERITE_SYNCED = SynchedEntityData.m_135353_(Pickarang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected LivingEntity owner;
    private UUID ownerId;
    private int liveTime;
    private int slot;
    private int blockHitCount;
    public boolean netherite;
    private IntOpenHashSet entitiesHit;
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_BLOCKS_BROKEN = "hitCount";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";
    private static final String TAG_NETHERITE = "netherite";

    public Pickarang(EntityType<? extends Pickarang> type, Level worldIn) {
        super(type, worldIn);
    }

    public Pickarang(Level worldIn, LivingEntity throwerIn) {
        super(PickarangModule.pickarangType, worldIn);
        Vec3 pos = throwerIn.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_ + (double)throwerIn.m_20192_(), pos.f_82481_);
        this.ownerId = throwerIn.m_142081_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        Vec3 Vector3d = entityThrower.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(Vector3d.f_82479_, entityThrower.m_20096_() ? 0.0 : Vector3d.f_82480_, Vector3d.f_82481_));
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec);
        float f = (float)vec.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = (float)Math.sqrt(x * x + z * z);
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void setThrowData(int slot, ItemStack stack, boolean netherite) {
        this.slot = slot;
        this.setStack(stack.m_41777_());
        this.netherite = netherite;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STACK, (Object)new ItemStack((ItemLike)PickarangModule.pickarang));
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(NETHERITE_SYNCED, (Object)false);
    }

    protected void checkImpact() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 position = this.m_20182_();
        Vec3 rayEnd = position.m_82549_(motion);
        boolean doEntities = true;
        int tries = 100;
        while (this.m_6084_() && !((Boolean)this.f_19804_.m_135370_(RETURNING)).booleanValue()) {
            if (doEntities) {
                result = this.raycastEntities(position, rayEnd);
                if (result != null) {
                    this.m_6532_((HitResult)result);
                } else {
                    doEntities = false;
                }
            } else {
                result = this.f_19853_.m_45547_(new ClipContext(position, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (result.m_6662_() == HitResult.Type.MISS) {
                    return;
                }
                this.m_6532_((HitResult)result);
            }
            if (tries-- > 0) continue;
            new RuntimeException("Pickarang hit way too much, this shouldn't happen").printStackTrace();
            return;
        }
    }

    @Nullable
    protected EntityHitResult raycastEntities(Vec3 from, Vec3 to) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)from, (Vec3)to, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !(entity.m_5833_() || !entity.m_6084_() || !entity.m_6087_() && !(entity instanceof Pickarang) || entity == this.getThrower() || this.entitiesHit != null && this.entitiesHit.contains(entity.m_142049_())));
    }

    protected void m_6532_(@Nonnull HitResult result) {
        Entity hit;
        LivingEntity owner = this.getThrower();
        if (result.m_6662_() == HitResult.Type.BLOCK && result instanceof BlockHitResult) {
            BlockPos hit2 = ((BlockHitResult)result).m_82425_();
            BlockState state = this.f_19853_.m_8055_(hit2);
            if (this.getPiercingModifier() == 0 || state.m_60767_().m_76337_()) {
                this.addHit();
            }
            if (!(owner instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)owner;
            float hardness = state.m_60800_((BlockGetter)this.f_19853_, hit2);
            if ((double)hardness <= PickarangModule.maxHardness && hardness >= 0.0f) {
                ItemStack prev = player.m_21205_();
                player.m_21008_(InteractionHand.MAIN_HAND, this.getStack());
                if (player.f_8941_.m_9280_(hit2)) {
                    this.f_19853_.m_5898_(null, 2001, hit2, Block.m_49956_((BlockState)state));
                } else {
                    this.clank();
                }
                this.setStack(player.m_21205_());
                player.m_21008_(InteractionHand.MAIN_HAND, prev);
            } else {
                this.clank();
            }
        } else if (result.m_6662_() == HitResult.Type.ENTITY && result instanceof EntityHitResult && (hit = ((EntityHitResult)result).m_82443_()) != owner) {
            this.addHit(hit);
            if (hit instanceof Pickarang) {
                ((Pickarang)hit).setReturning();
                this.clank();
            } else {
                ItemStack pickarang = this.getStack();
                Multimap modifiers = pickarang.m_41638_(EquipmentSlot.MAINHAND);
                if (owner != null) {
                    Toretoise toretoise;
                    int ore;
                    ItemStack prev = owner.m_21205_();
                    owner.m_21008_(InteractionHand.MAIN_HAND, pickarang);
                    owner.m_21204_().m_22178_(modifiers);
                    int ticksSinceLastSwing = owner.f_20922_;
                    owner.f_20922_ = (int)(1.0 / owner.m_21133_(Attributes.f_22283_) * 20.0) + 1;
                    float prevHealth = hit instanceof LivingEntity ? ((LivingEntity)hit).m_21223_() : 0.0f;
                    PickarangModule.setActivePickarang(this);
                    if (hit instanceof Toretoise && (ore = (toretoise = (Toretoise)hit).getOreType()) != 0) {
                        this.addHit((Entity)toretoise);
                        toretoise.dropOre(ore);
                    } else {
                        if (owner instanceof Player) {
                            ((Player)owner).m_5706_(hit);
                        } else {
                            owner.m_7327_(hit);
                        }
                        if (hit instanceof LivingEntity && ((LivingEntity)hit).m_21223_() == prevHealth) {
                            this.clank();
                        }
                    }
                    PickarangModule.setActivePickarang(null);
                    owner.f_20922_ = ticksSinceLastSwing;
                    this.setStack(owner.m_21205_());
                    owner.m_21008_(InteractionHand.MAIN_HAND, prev);
                    owner.m_21204_().m_22178_(modifiers);
                } else {
                    AttributeSupplier.Builder mapBuilder = new AttributeSupplier.Builder();
                    mapBuilder.m_22268_(Attributes.f_22281_, 1.0);
                    AttributeSupplier map = mapBuilder.m_22265_();
                    AttributeMap manager = new AttributeMap(map);
                    manager.m_22178_(modifiers);
                    ItemStack stack = this.getStack();
                    stack.m_41629_(1, this.f_19853_.f_46441_, null);
                    this.setStack(stack);
                    hit.m_6469_(new IndirectEntityDamageSource("player", (Entity)this, (Entity)this).m_19366_(), (float)manager.m_22181_(Attributes.f_22281_));
                }
            }
        }
    }

    public void spark() {
        this.m_5496_(QuarkSounds.ENTITY_PICKARANG_SPARK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void clank() {
        this.m_5496_(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void addHit(Entity entity) {
        if (this.entitiesHit == null) {
            this.entitiesHit = new IntOpenHashSet(5);
        }
        this.entitiesHit.add(entity.m_142049_());
        this.postHit();
    }

    public void postHit() {
        if ((this.entitiesHit == null ? 0 : this.entitiesHit.size()) + this.blockHitCount > this.getPiercingModifier()) {
            this.setReturning();
        } else if (this.getPiercingModifier() > 0) {
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        }
    }

    public void addHit() {
        ++this.blockHitCount;
        this.postHit();
    }

    protected void setReturning() {
        this.f_19804_.m_135381_(RETURNING, (Object)true);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        float drag;
        Vec3 pos = this.m_20182_();
        this.f_19790_ = pos.f_82479_;
        this.f_19791_ = pos.f_82480_;
        this.f_19792_ = pos.f_82481_;
        super.m_8119_();
        if (!((Boolean)this.f_19804_.m_135370_(RETURNING)).booleanValue()) {
            this.checkImpact();
        }
        Vec3 ourMotion = this.m_20184_();
        this.m_6034_(pos.f_82479_ + ourMotion.f_82479_, pos.f_82480_ + ourMotion.f_82480_, pos.f_82481_ + ourMotion.f_82481_);
        float f = (float)ourMotion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)ourMotion.f_82479_, (double)ourMotion.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)ourMotion.f_82480_, (double)f) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ - ourMotion.f_82479_ * 0.25, pos.f_82480_ - ourMotion.f_82480_ * 0.25, pos.f_82481_ - ourMotion.f_82481_ * 0.25, ourMotion.f_82479_, ourMotion.f_82480_, ourMotion.f_82481_);
            }
            drag = 0.8f;
        } else {
            drag = 0.99f;
        }
        this.m_20256_(ourMotion.m_82490_((double)drag));
        pos = this.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        if (!this.m_6084_()) {
            return;
        }
        ItemStack stack = this.getStack();
        if (((Boolean)this.f_19804_.m_135370_(NETHERITE_SYNCED)).booleanValue()) {
            if (Math.random() < 0.4) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ - ourMotion.f_82479_ * 0.25 + (Math.random() - 0.5) * 0.4, pos.f_82480_ - ourMotion.f_82480_ * 0.25 + (Math.random() - 0.5) * 0.4, pos.f_82481_ - ourMotion.f_82481_ * 0.25 + (Math.random() - 0.5) * 0.4, (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1);
            }
        } else if (!this.f_19853_.f_46443_ && this.netherite) {
            this.f_19804_.m_135381_(NETHERITE_SYNCED, (Object)true);
        }
        boolean returning = (Boolean)this.f_19804_.m_135370_(RETURNING);
        ++this.liveTime;
        LivingEntity owner = this.getThrower();
        if (owner == null || !owner.m_6084_() || !(owner instanceof Player)) {
            if (!this.f_19853_.f_46443_) {
                while (this.m_5830_()) {
                    this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                }
                this.m_5552_(stack, 0.0f);
                this.m_146870_();
            }
            return;
        }
        if (!returning) {
            if (this.liveTime > PickarangModule.timeout) {
                this.setReturning();
            }
            if (!this.f_19853_.m_6857_().m_61935_(this.m_142469_())) {
                this.spark();
            }
        } else {
            this.f_19794_ = true;
            int eff = this.getEfficiencyModifier();
            List items = this.f_19853_.m_45976_(ItemEntity.class, this.m_142469_().m_82400_(2.0));
            List xp = this.f_19853_.m_45976_(ExperienceOrb.class, this.m_142469_().m_82400_(2.0));
            Vec3 ourPos = this.m_20182_();
            for (ItemEntity item : items) {
                if (item.m_20159_()) continue;
                item.m_20329_((Entity)this);
                item.m_32010_(2);
            }
            for (ExperienceOrb xpOrb : xp) {
                if (xpOrb.m_20159_()) continue;
                xpOrb.m_20329_((Entity)this);
            }
            Vec3 ownerPos = owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 motion = ownerPos.m_82546_(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.m_82556_() < motionMag) {
                Player player = (Player)owner;
                Inventory inventory = player.m_150109_();
                ItemStack stackInSlot = inventory.m_8020_(this.slot);
                if (!this.f_19853_.f_46443_) {
                    this.m_5496_(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (!stack.m_41619_()) {
                        if (player.m_6084_() && stackInSlot.m_41619_()) {
                            inventory.m_6836_(this.slot, stack);
                        } else if (!player.m_6084_() || !inventory.m_36054_(stack)) {
                            player.m_36176_(stack, false);
                        }
                    }
                    if (player.m_6084_()) {
                        for (ItemEntity item : items) {
                            if (!item.m_6084_()) continue;
                            this.giveItemToPlayer(player, item);
                        }
                        for (ExperienceOrb xpOrb : xp) {
                            if (!xpOrb.m_6084_()) continue;
                            xpOrb.m_6123_(player);
                        }
                        for (Entity riding : this.m_20197_()) {
                            if (!riding.m_6084_()) continue;
                            if (riding instanceof ItemEntity) {
                                this.giveItemToPlayer(player, (ItemEntity)riding);
                                continue;
                            }
                            if (!(riding instanceof ExperienceOrb)) continue;
                            riding.m_6123_(player);
                        }
                    }
                    this.m_146870_();
                }
            } else {
                this.m_20256_(motion.m_82541_().m_82490_(0.7 + (double)((float)eff * 0.325f)));
            }
        }
    }

    private void giveItemToPlayer(Player player, ItemEntity itemEntity) {
        itemEntity.m_32010_(0);
        itemEntity.m_6123_(player);
        if (itemEntity.m_6084_()) {
            ItemStack drop = itemEntity.m_32055_();
            player.m_36176_(drop, false);
            itemEntity.m_146870_();
        }
    }

    @Nullable
    public LivingEntity getThrower() {
        if (this.owner == null && this.ownerId != null && this.f_19853_ instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerId);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            } else {
                this.ownerId = null;
            }
        }
        return this.owner;
    }

    protected boolean m_7310_(Entity passenger) {
        return super.m_7310_(passenger) || passenger instanceof ItemEntity || passenger instanceof ExperienceOrb;
    }

    public double m_6048_() {
        return 0.0;
    }

    @Nonnull
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    public int getEfficiencyModifier() {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)this.getStack());
    }

    public int getPiercingModifier() {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)this.getStack());
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void setStack(ItemStack stack) {
        this.f_19804_.m_135381_(STACK, (Object)stack);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        Tag owner;
        this.f_19804_.m_135381_(RETURNING, (Object)compound.m_128471_(TAG_RETURNING));
        this.liveTime = compound.m_128451_(TAG_LIVE_TIME);
        this.blockHitCount = compound.m_128451_(TAG_BLOCKS_BROKEN);
        this.slot = compound.m_128451_(TAG_RETURN_SLOT);
        if (compound.m_128441_(TAG_ITEM_STACK)) {
            this.setStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack((ItemLike)PickarangModule.pickarang));
        }
        if (compound.m_128425_("owner", 10) && (owner = compound.m_128423_("owner")) != null) {
            this.ownerId = NbtUtils.m_129233_((Tag)owner);
        }
        this.netherite = compound.m_128471_(TAG_NETHERITE);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        compound.m_128379_(TAG_RETURNING, ((Boolean)this.f_19804_.m_135370_(RETURNING)).booleanValue());
        compound.m_128405_(TAG_LIVE_TIME, this.liveTime);
        compound.m_128405_(TAG_BLOCKS_BROKEN, this.blockHitCount);
        compound.m_128405_(TAG_RETURN_SLOT, this.slot);
        compound.m_128365_(TAG_ITEM_STACK, (Tag)this.getStack().serializeNBT());
        if (this.ownerId != null) {
            compound.m_128365_("owner", (Tag)NbtUtils.m_129226_((UUID)this.ownerId));
        }
        compound.m_128379_(TAG_NETHERITE, this.netherite);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

