/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.client.render.GlintRenderTypes;
import vazkii.quark.content.tools.item.RuneItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class ColorRunesModule
extends QuarkModule {
    public static final String TAG_RUNE_ATTACHED = "quark:RuneAttached";
    public static final String TAG_RUNE_COLOR = "quark:RuneColor";
    public static final int RUNE_TYPES = 17;
    private static final ThreadLocal<ItemStack> targetStack = new ThreadLocal();
    public static Tag<Item> runesTag;
    public static Tag<Item> runesLootableTag;
    public static Item blank_rune;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    @Config
    public static int applyCost;

    public static void setTargetStack(ItemStack stack) {
        targetStack.set(stack);
    }

    public static int changeColor() {
        ItemStack target = targetStack.get();
        if (target == null) {
            return -1;
        }
        LazyOptional<IRuneColorProvider> cap = ColorRunesModule.get((ICapabilityProvider)target);
        if (cap.isPresent()) {
            return ((IRuneColorProvider)cap.orElse(s -> -1)).getRuneColor(target);
        }
        if (!ItemNBTHelper.getBoolean((ItemStack)target, (String)TAG_RUNE_ATTACHED, (boolean)false)) {
            return -1;
        }
        ItemStack proxied = ItemStack.m_41712_((CompoundTag)ItemNBTHelper.getCompound((ItemStack)target, (String)TAG_RUNE_COLOR, (boolean)false));
        LazyOptional<IRuneColorProvider> proxyCap = ColorRunesModule.get((ICapabilityProvider)proxied);
        int color = ((IRuneColorProvider)proxyCap.orElse(s -> -1)).getRuneColor(target);
        return color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.glint, RenderType::m_110490_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlintTranslucent() {
        return ColorRunesModule.renderType(GlintRenderTypes.glintTranslucent, RenderType::m_110487_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.entityGlint, RenderType::m_110496_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlintDirect() {
        return ColorRunesModule.renderType(GlintRenderTypes.glintDirect, RenderType::m_110493_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlintDirect() {
        return ColorRunesModule.renderType(GlintRenderTypes.entityGlintDirect, RenderType::m_110499_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.armorGlint, RenderType::m_110481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorEntityGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.armorEntityGlint, RenderType::m_110484_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RenderType renderType(List<RenderType> list, Supplier<RenderType> vanilla) {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 17 ? list.get(color) : vanilla.get();
    }

    @Override
    public void construct() {
        for (DyeColor color : DyeColor.values()) {
            new RuneItem(color.m_7912_() + "_rune", this, color.m_41060_(), true);
        }
        new RuneItem("rainbow_rune", this, 16, true);
        blank_rune = new RuneItem("blank_rune", this, 17, false);
    }

    @Override
    public void setup() {
        runesTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "runes"));
        runesLootableTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "runes_lootable"));
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.f_78742_)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78760_)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78686_)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78764_)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)blank_rune).m_79707_(weight).m_79711_(itemQuality).m_7512_();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack output = event.getOutput();
        if (!left.m_41619_() && !right.m_41619_() && ColorRunesModule.canHaveRune(left) && right.m_150922_(runesTag)) {
            ItemStack out = (output.m_41619_() ? left : output).m_41777_();
            ItemNBTHelper.setBoolean((ItemStack)out, (String)TAG_RUNE_ATTACHED, (boolean)true);
            ItemNBTHelper.setCompound((ItemStack)out, (String)TAG_RUNE_COLOR, (CompoundTag)right.serializeNBT());
            event.setOutput(out);
            event.setCost(Math.max(1, applyCost));
            event.setMaterialCost(1);
        }
    }

    private static boolean canHaveRune(ItemStack stack) {
        return stack.m_41793_() || stack.m_41720_() == Items.f_42522_ && CompassItem.m_40736_((ItemStack)stack);
    }

    private static LazyOptional<IRuneColorProvider> get(ICapabilityProvider provider) {
        return provider.getCapability(QuarkCapabilities.RUNE_COLOR);
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        applyCost = 5;
    }
}

