/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.client.tooltip.SeedPouchClientTooltipComponent;
import vazkii.quark.content.tools.item.SeedPouchItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class SeedPouchModule
extends QuarkModule {
    public static Item seed_pouch;
    public static Tag<Item> seedPouchHoldableTag;
    @Config
    public static int maxItems;
    @Config
    public static boolean showAllVariantsInCreative;
    @Config
    public static int shiftRange;

    @Override
    public void construct() {
        seed_pouch = new SeedPouchItem(this);
    }

    @Override
    public void setup() {
        seedPouchHoldableTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "seed_pouch_holdable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.enqueue(() -> ItemProperties.register((Item)seed_pouch, (ResourceLocation)new ResourceLocation("pouch_items"), SeedPouchItem::itemFraction));
        MinecraftForgeClient.registerTooltipComponentFactory(SeedPouchItem.Tooltip.class, t -> new SeedPouchClientTooltipComponent(t.stack));
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getItem().m_32055_();
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        ImmutableSet stacks = ImmutableSet.of((Object)main, (Object)off);
        for (ItemStack heldStack : stacks) {
            ItemStack pouchStack;
            Pair<ItemStack, Integer> contents;
            if (heldStack.m_41720_() != seed_pouch || (contents = SeedPouchItem.getContents(heldStack)) == null || !ItemStack.m_41746_((ItemStack)(pouchStack = (ItemStack)contents.getLeft()), (ItemStack)stack)) continue;
            int curr = (Integer)contents.getRight();
            int missing = maxItems - curr;
            int count = stack.m_41613_();
            int toAdd = Math.min(missing, count);
            stack.m_41764_(count - toAdd);
            SeedPouchItem.setCount(heldStack, curr + toAdd);
            if (player.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)player.f_19853_).m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.2f, (player.f_19853_.f_46441_.nextFloat() - player.f_19853_.f_46441_.nextFloat()) * 1.4f + 2.0f);
            }
            if (stack.m_41613_() != 0) continue;
            break;
        }
    }

    static {
        maxItems = 640;
        showAllVariantsInCreative = true;
        shiftRange = 3;
    }
}

