/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.item;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.content.tweaks.module.CompassesWorkEverywhereModule;

public class CompassAngleGetter {
    private static final String TAG_CALCULATED = "quark:compass_calculated";
    private static final String TAG_WAS_IN_NETHER = "quark:compass_in_nether";
    private static final String TAG_POSITION_SET = "quark:compass_position_set";
    private static final String TAG_NETHER_TARGET_X = "quark:nether_x";
    private static final String TAG_NETHER_TARGET_Z = "quark:nether_z";

    public static void tickCompass(Player player, ItemStack stack) {
        boolean calculated = CompassAngleGetter.isCalculated(stack);
        boolean nether = player.f_19853_.m_46472_().m_135782_().equals((Object)LevelStem.f_63972_.m_135782_());
        if (calculated) {
            boolean isInPortal;
            boolean wasInNether = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
            BlockPos pos = player.m_142538_();
            boolean bl = isInPortal = player.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50142_;
            if (nether && !wasInNether && isInPortal) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)pos.m_123341_());
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)pos.m_123343_());
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)true);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)true);
            } else if (!nether && wasInNether) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false);
            }
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)nether);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Impl
    implements ItemPropertyFunction {
        private final Angle normalAngle = new Angle();
        private final Angle unknownAngle = new Angle();

        @OnlyIn(value=Dist.CLIENT)
        public float m_141951_(@Nonnull ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int id) {
            double angle;
            BlockPos lodestonePos;
            LivingEntity entity;
            if (entityIn == null && !stack.m_41794_()) {
                return 0.0f;
            }
            if (!(!CompassesWorkEverywhereModule.enableCompassNerf || stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)CompassAngleGetter.TAG_CALCULATED, (boolean)false))) {
                return 0.0f;
            }
            boolean carried = entityIn != null;
            Object object = entity = carried ? entityIn : stack.m_41795_();
            if (entity == null) {
                return 0.0f;
            }
            if (worldIn == null && entity != null && entity.f_19853_ instanceof ClientLevel) {
                worldIn = (ClientLevel)entity.f_19853_;
            }
            boolean calculate = false;
            BlockPos target = new BlockPos(0, 0, 0);
            ResourceLocation dimension = worldIn.m_46472_().m_135782_();
            BlockPos blockPos = lodestonePos = CompassItem.m_40736_((ItemStack)stack) ? this.getLodestonePosition((Level)worldIn, stack.m_41784_()) : null;
            if (lodestonePos != null) {
                calculate = true;
                target = lodestonePos;
            } else if (dimension.equals((Object)LevelStem.f_63973_.m_135782_()) && CompassesWorkEverywhereModule.enableEnd) {
                calculate = true;
            } else if (dimension.equals((Object)LevelStem.f_63972_.m_135782_()) && CompassAngleGetter.isCalculated(stack) && CompassesWorkEverywhereModule.enableNether) {
                boolean set = ItemNBTHelper.getBoolean((ItemStack)stack, (String)CompassAngleGetter.TAG_POSITION_SET, (boolean)false);
                if (set) {
                    int x = ItemNBTHelper.getInt((ItemStack)stack, (String)CompassAngleGetter.TAG_NETHER_TARGET_X, (int)0);
                    int z = ItemNBTHelper.getInt((ItemStack)stack, (String)CompassAngleGetter.TAG_NETHER_TARGET_Z, (int)0);
                    calculate = true;
                    target = new BlockPos(x, 0, z);
                }
            } else if (worldIn.m_6042_().m_63956_()) {
                calculate = true;
                target = this.getWorldSpawn(worldIn);
            }
            long gameTime = worldIn.m_46467_();
            if (calculate && target != null) {
                double d1 = carried ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
                d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                double d2 = this.getAngleToPosition((Entity)entity, target) / (Math.PI * 2);
                if (carried) {
                    if (this.normalAngle.needsUpdate(gameTime)) {
                        this.normalAngle.wobble(gameTime, 0.5 - (d1 - 0.25));
                    }
                    angle = d2 + this.normalAngle.rotation;
                } else {
                    angle = 0.5 - (d1 - 0.25 - d2);
                }
            } else {
                if (this.unknownAngle.needsUpdate(gameTime)) {
                    this.unknownAngle.wobble(gameTime, Math.random());
                }
                angle = this.unknownAngle.rotation + (double)worldIn.hashCode() / Math.PI;
            }
            return Mth.m_14091_((float)((float)angle), (float)1.0f);
        }

        private double getFrameRotation(ItemFrame frame) {
            return Mth.m_14177_((float)(180.0f + frame.m_6350_().m_122435_()));
        }

        private double getAngleToPosition(Entity entity, BlockPos blockpos) {
            Vec3 pos = entity.m_20182_();
            return Math.atan2((double)blockpos.m_123343_() - pos.f_82481_, (double)blockpos.m_123341_() - pos.f_82479_);
        }

        @Nullable
        private BlockPos getLodestonePosition(Level p_239442_1_, CompoundTag p_239442_2_) {
            Optional optional;
            boolean flag = p_239442_2_.m_128441_("LodestonePos");
            boolean flag1 = p_239442_2_.m_128441_("LodestoneDimension");
            if (flag && flag1 && (optional = CompassItem.m_40727_((CompoundTag)p_239442_2_)).isPresent() && p_239442_1_.m_46472_().equals(optional.get())) {
                return NbtUtils.m_129239_((CompoundTag)p_239442_2_.m_128469_("LodestonePos"));
            }
            return null;
        }

        @Nullable
        private BlockPos getWorldSpawn(ClientLevel p_239444_1_) {
            return p_239444_1_.m_6042_().m_63956_() ? p_239444_1_.m_104822_() : null;
        }

        @OnlyIn(value=Dist.CLIENT)
        private static class Angle {
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            private Angle() {
            }

            private boolean needsUpdate(long p_239448_1_) {
                return this.lastUpdateTick != p_239448_1_;
            }

            private void wobble(long gameTime, double angle) {
                this.lastUpdateTick = gameTime;
                double d0 = angle - this.rotation;
                d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                this.rota += d0 * 0.1;
                this.rota *= 0.8;
                this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
            }
        }
    }
}

