/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class ReplaceScaffoldingModule
extends QuarkModule {
    @Config(description="How many times the algorithm for finding out where a block would be placed is allowed to turn. If you set this to large values (> 3) it may start producing weird effects.")
    public int maxBounces = 1;

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        Player player = event.getPlayer();
        if (state.m_60734_() == Blocks.f_50616_ && !player.m_20163_()) {
            BlockPos last;
            UseOnContext context;
            BlockPlaceContext bcontext;
            BlockState stateToPlace;
            BlockItem bitem;
            Block block;
            Direction dir = event.getFace();
            ItemStack stack = event.getItemStack();
            InteractionHand hand = event.getHand();
            if (stack.m_41720_() instanceof BlockItem && (block = (bitem = (BlockItem)stack.m_41720_()).m_40614_()) != Blocks.f_50616_ && !(block instanceof EntityBlock) && (stateToPlace = block.m_5573_(bcontext = new BlockPlaceContext(context = new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.5, 1.0, 0.5), dir, last = this.getLastInLine(world, pos, dir), false))))) != null && stateToPlace.m_60710_((LevelReader)world, last)) {
                BlockState currState = world.m_8055_(last);
                world.m_46597_(last, stateToPlace);
                BlockPos testUp = last.m_7494_();
                BlockState testUpState = world.m_8055_(testUp);
                if (testUpState.m_60734_() == Blocks.f_50616_ && !stateToPlace.m_60783_((BlockGetter)world, last, Direction.UP)) {
                    world.m_46597_(last, currState);
                    return;
                }
                world.m_5594_(player, last, stateToPlace.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    ItemStack giveStack = new ItemStack((ItemLike)Items.f_42340_);
                    if (!player.m_36356_(giveStack)) {
                        player.m_36176_(giveStack, false);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private BlockPos getLastInLine(Level world, BlockPos start, Direction clickDir) {
        BlockPos result = this.getLastInLineOrNull(world, start, clickDir);
        if (result != null) {
            return result;
        }
        if (clickDir != Direction.UP && (result = this.getLastInLineOrNull(world, start, Direction.UP)) != null) {
            return result;
        }
        for (Direction horizontal : MiscUtil.HORIZONTALS) {
            if (horizontal == clickDir || (result = this.getLastInLineOrNull(world, start, horizontal)) == null) continue;
            return result;
        }
        if (clickDir != Direction.DOWN && (result = this.getLastInLineOrNull(world, start, Direction.DOWN)) != null) {
            return result;
        }
        return start;
    }

    private BlockPos getLastInLineOrNull(Level world, BlockPos start, Direction dir) {
        BlockPos last = this.getLastInLineRecursive(world, start, dir, this.maxBounces);
        if (last.equals((Object)start)) {
            return null;
        }
        return last;
    }

    private BlockPos getLastInLineRecursive(Level world, BlockPos start, Direction dir, int bouncesAllowed) {
        BlockState testState;
        BlockPos test;
        BlockPos curr = start;
        BlockState currState = world.m_8055_(start);
        Block currBlock = currState.m_60734_();
        while (world.m_46749_(test = curr.m_142300_(dir)) && (testState = world.m_8055_(test)).m_60734_() == currBlock) {
            curr = test;
        }
        if (!curr.equals((Object)start) && bouncesAllowed > 0) {
            BlockPos maxDist = null;
            double maxDistVal = -1.0;
            for (Direction dir2 : Direction.values()) {
                BlockPos testDist;
                double testDistVal;
                BlockPos bounceStart;
                if (dir.m_122434_() == dir2.m_122434_() || world.m_8055_(bounceStart = curr.m_142300_(dir2)).m_60734_() != currBlock || !((testDistVal = (double)(testDist = this.getLastInLineRecursive(world, bounceStart, dir2, bouncesAllowed - 1)).m_123333_((Vec3i)curr)) > maxDistVal)) continue;
                maxDist = testDist;
            }
            if (maxDist != null) {
                curr = maxDist;
            }
        }
        return curr;
    }
}

