/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.ChorusVegetationModule;

public class ChorusVegetationBlock
extends QuarkBlock
implements BonemealableBlock,
IForgeShearable {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final boolean simple;

    public ChorusVegetationBlock(String regname, QuarkModule module, boolean simple) {
        super(regname, module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_60977_());
        this.simple = simple;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (random.nextDouble() < ChorusVegetationModule.passiveTeleportChance) {
            this.teleport(pos, random, worldIn, state);
        }
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.2 + rand.nextDouble() * 0.6, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.2 + rand.nextDouble() * 0.6, 0.0, 0.0, 0.0);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        BlockPos target;
        if (this.simple && worldIn instanceof ServerLevel && entity instanceof LivingEntity && !(entity instanceof EnderMan) && !(entity instanceof Endermite) && (target = this.teleport(pos, worldIn.f_46441_, (ServerLevel)worldIn, state)) != null && worldIn.f_46441_.nextDouble() < ChorusVegetationModule.endermiteSpawnChance) {
            Endermite mite = new Endermite(EntityType.f_20567_, worldIn);
            mite.m_6034_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_());
            worldIn.m_7967_((Entity)mite);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof ServerLevel) {
            this.runAwayFromWater(pos, worldIn.f_46441_, (ServerLevel)worldIn, state);
        }
    }

    private void runAwayFromWater(BlockPos pos, Random random, ServerLevel worldIn, BlockState state) {
        for (Direction d : Direction.values()) {
            BlockPos test = pos.m_142300_(d);
            FluidState fluid = worldIn.m_6425_(test);
            if (fluid.m_76152_() != Fluids.f_76193_ && fluid.m_76152_() != Fluids.f_76192_) continue;
            this.teleport(pos, random, worldIn, state, 8, 1.0);
            return;
        }
    }

    private BlockPos teleport(BlockPos pos, Random random, ServerLevel worldIn, BlockState state) {
        return this.teleport(pos, random, worldIn, state, 4, 1.0 - ChorusVegetationModule.teleportDuplicationChance);
    }

    private BlockPos teleport(BlockPos pos, Random random, ServerLevel worldIn, BlockState state, int range, double growthChance) {
        BlockState stateAt;
        int xOff = 0;
        int zOff = 0;
        do {
            xOff = random.nextInt(range + 1) - range / 2;
            zOff = random.nextInt(range + 1) - range / 2;
        } while (xOff == 0 && zOff == 0);
        BlockPos newPos = pos.m_142082_(xOff, 10, zOff);
        for (int i = 0; i < 20 && (stateAt = worldIn.m_8055_(newPos)).m_60734_() != Blocks.f_50259_; ++i) {
            newPos = newPos.m_7495_();
        }
        if (worldIn.m_8055_(newPos).m_60734_() == Blocks.f_50259_ && worldIn.m_8055_(newPos.m_7494_()).m_60795_()) {
            newPos = newPos.m_7494_();
            worldIn.m_46597_(newPos, state);
            if (random.nextDouble() < growthChance) {
                worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.25, (double)pos.m_123343_(), 50, 0.25, 0.25, 0.25, 1.0);
                worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.1f, 5.0f + random.nextFloat());
            }
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() - 0.25, (double)newPos.m_123343_(), 50, 0.25, 0.25, 0.25, 0.05);
            return newPos;
        }
        return null;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        for (int i = 0; i < 3 + rand.nextInt(3); ++i) {
            this.teleport(pos, rand, worldIn, state, 10, 0.0);
        }
        this.teleport(pos, rand, worldIn, state, 4, 1.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50259_;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(state, worldIn, pos, type);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }
}

