/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.content.world.block.CorundumBlock;

public class CorundumClusterBlock
extends QuarkBlock
implements SimpleWaterloggedBlock {
    public final CorundumBlock base;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static VoxelShape northAabb;
    protected static VoxelShape southAabb;
    protected static VoxelShape eastAabb;
    protected static VoxelShape westAabb;
    protected static VoxelShape upAabb;
    protected static VoxelShape downAabb;

    public CorundumClusterBlock(CorundumBlock base) {
        super(base.getRegistryName().m_135815_() + "_cluster", base.getModule(), CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)base).m_60918_(SoundType.f_154655_));
        this.base = base;
        base.cluster = this;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState p_152021_, BlockGetter p_152022_, BlockPos p_152023_, CollisionContext p_152024_) {
        Direction direction = (Direction)p_152021_.m_61143_(FACING);
        switch (direction) {
            case NORTH: {
                return northAabb;
            }
            case SOUTH: {
                return southAabb;
            }
            case EAST: {
                return eastAabb;
            }
            case WEST: {
                return westAabb;
            }
            case DOWN: {
                return downAabb;
            }
        }
        return upAabb;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_(FACING);
        BlockPos off = pos.m_142300_(dir.m_122424_());
        BlockState offState = worldIn.m_8055_(off);
        return offState.m_60783_((BlockGetter)worldIn, off, dir);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    static {
        int p_152015_ = 7;
        int p_152016_ = 3;
        upAabb = Block.m_49796_((double)p_152016_, (double)0.0, (double)p_152016_, (double)(16 - p_152016_), (double)p_152015_, (double)(16 - p_152016_));
        downAabb = Block.m_49796_((double)p_152016_, (double)(16 - p_152015_), (double)p_152016_, (double)(16 - p_152016_), (double)16.0, (double)(16 - p_152016_));
        northAabb = Block.m_49796_((double)p_152016_, (double)p_152016_, (double)(16 - p_152015_), (double)(16 - p_152016_), (double)(16 - p_152016_), (double)16.0);
        southAabb = Block.m_49796_((double)p_152016_, (double)p_152016_, (double)0.0, (double)(16 - p_152016_), (double)(16 - p_152016_), (double)p_152015_);
        eastAabb = Block.m_49796_((double)0.0, (double)p_152016_, (double)p_152016_, (double)p_152015_, (double)(16 - p_152016_), (double)(16 - p_152016_));
        westAabb = Block.m_49796_((double)(16 - p_152015_), (double)p_152016_, (double)p_152016_, (double)16.0, (double)(16 - p_152016_), (double)(16 - p_152016_));
    }
}

