/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.world.module.FairyRingsModule;

public class FairyRingGenerator
extends Generator {
    public FairyRingGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos corner) {
        int x = corner.m_123341_() + rand.nextInt(16);
        int z = corner.m_123343_() + rand.nextInt(16);
        BlockPos center = new BlockPos(x, 128, z);
        Biome biome = this.getBiome((LevelAccessor)worldIn, center, false);
        Biome.BiomeCategory category = biome.m_47567_();
        double chance = 0.0;
        if (category == Biome.BiomeCategory.FOREST) {
            chance = FairyRingsModule.forestChance;
        } else if (category == Biome.BiomeCategory.PLAINS) {
            chance = FairyRingsModule.plainsChance;
        }
        if (rand.nextDouble() < chance) {
            BlockPos pos = center;
            BlockState state = worldIn.m_8055_(pos);
            while (state.m_60767_() != Material.f_76315_ && pos.m_123342_() > 30) {
                pos = pos.m_7495_();
                state = worldIn.m_8055_(pos);
            }
            if (state.m_60767_() == Material.f_76315_) {
                FairyRingGenerator.spawnFairyRing((LevelAccessor)worldIn, pos.m_7495_(), rand);
            }
        }
    }

    public static void spawnFairyRing(LevelAccessor world, BlockPos pos, Random rand) {
        BlockState flower = Blocks.f_50120_.m_49966_();
        for (int i = -3; i <= 3; ++i) {
            block1: for (int j = -3; j <= 3; ++j) {
                float dist = i * i + j * j;
                if (dist < 7.0f || dist > 10.0f) continue;
                for (int k = 5; k > -4; --k) {
                    BlockPos fpos = pos.m_142082_(i, k, j);
                    BlockPos fposUp = fpos.m_7494_();
                    BlockState state = world.m_8055_(fpos);
                    if (state.m_60767_() != Material.f_76315_ || !world.m_46859_(fposUp)) continue;
                    world.m_7731_(fpos.m_7494_(), flower, 2);
                    continue block1;
                }
            }
        }
        BlockPos orePos = pos.m_6625_(rand.nextInt(10) + 25);
        BlockState stoneState = world.m_8055_(orePos);
        for (int down = 0; !stoneState.m_60620_((Tag)Tags.Blocks.STONE) && down < 10; ++down) {
            orePos = orePos.m_7495_();
            stoneState = world.m_8055_(orePos);
        }
        if (stoneState.m_60620_((Tag)Tags.Blocks.STONE)) {
            BlockState ore = FairyRingsModule.ores.get(rand.nextInt(FairyRingsModule.ores.size()));
            world.m_7731_(orePos, ore, 2);
            for (Direction face : Direction.values()) {
                if (!rand.nextBoolean()) continue;
                world.m_7731_(orePos.m_142300_(face), ore, 2);
            }
        }
    }
}

