/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import java.util.function.Function;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.UndergroundBiomeHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.mobs.module.StonelingsModule;
import vazkii.quark.content.world.block.GlowLichenGrowthBlock;
import vazkii.quark.content.world.block.GlowShroomBlock;
import vazkii.quark.content.world.block.GlowShroomRingBlock;
import vazkii.quark.content.world.block.HugeGlowShroomBlock;
import vazkii.quark.content.world.feature.GlowExtrasFeature;
import vazkii.quark.content.world.feature.GlowShroomsFeature;

@LoadModule(category=ModuleCategory.WORLD)
public class GlimmeringWealdModule
extends QuarkModule {
    private static final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    public static final ResourceLocation BIOME_NAME = new ResourceLocation("quark", "glimmering_weald");
    public static final PlacedFeature ORE_LAPIS_EXTRA = PlacementUtils.m_195368_((String)"ore_lapis_glimmering_weald", (PlacedFeature)OreFeatures.f_195062_.m_190821_(OrePlacements.m_195343_((int)12, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)0)))));
    public static PlacedFeature placed_glow_shrooms;
    public static PlacedFeature placed_glow_extras;
    public static Block glow_shroom;
    public static Block glow_lichen_growth;
    public static Block glow_shroom_block;
    public static Block glow_shroom_stem;
    public static Block glow_shroom_ring;
    public static Tag<Item> glowShroomFeedablesTag;

    @Override
    public void construct() {
        glow_shroom = new GlowShroomBlock(this);
        glow_lichen_growth = new GlowLichenGrowthBlock(this);
        glow_shroom_block = new HugeGlowShroomBlock("glow_shroom_block", this, true);
        glow_shroom_stem = new HugeGlowShroomBlock("glow_shroom_stem", this, false);
        glow_shroom_ring = new GlowShroomRingBlock(this);
        GlimmeringWealdModule.makeFeatures();
        RegistryHelper.register((IForgeRegistryEntry)GlimmeringWealdModule.makeBiome());
        UndergroundBiomeHandler.addUndergroundBiome(this, Climate.m_186798_((Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186822_((float)1.55f, (float)2.0f), (Climate.Parameter)FULL_RANGE, (float)0.0f), BIOME_NAME);
    }

    @Override
    public void setup() {
        glowShroomFeedablesTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "glow_shroom_feedables"));
    }

    private static void makeFeatures() {
        placed_glow_shrooms = GlimmeringWealdModule.place("glow_shrooms", new GlowShroomsFeature(), GlowShroomsFeature::placed);
        placed_glow_extras = GlimmeringWealdModule.place("glow_extras", new GlowExtrasFeature(), GlowExtrasFeature::placed);
    }

    private static PlacedFeature place(String featureName, Feature<NoneFeatureConfiguration> feature, Function<ConfiguredFeature<NoneFeatureConfiguration, ?>, PlacedFeature> placer) {
        String name = "quark:" + featureName;
        feature.setRegistryName(name);
        RegistryHelper.register(feature);
        ConfiguredFeature configured = FeatureUtils.m_195005_((String)name, (ConfiguredFeature)feature.m_65815_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        return PlacementUtils.m_195368_((String)name, (PlacedFeature)placer.apply(configured));
    }

    private static Biome makeBiome() {
        MobSpawnSettings.Builder mobs = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobs);
        if (ModuleLoader.INSTANCE.isModuleEnabled(StonelingsModule.class)) {
            mobs.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(StonelingsModule.stonelingType, 200, 1, 4));
        }
        mobs.m_48376_(MobCategory.UNDERGROUND_WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147034_, 20, 4, 6));
        BiomeGenerationSettings.Builder settings = new BiomeGenerationSettings.Builder();
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_194722_((BiomeGenerationSettings.Builder)settings, (boolean)true);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)settings);
        settings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, placed_glow_shrooms);
        settings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, placed_glow_extras);
        settings.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_LAPIS_EXTRA);
        Music music = Musics.m_11653_((SoundEvent)QuarkSounds.MUSIC_GLIMMERING_WEALD);
        Biome biome = OverworldBiomes.m_194861_((Biome.Precipitation)Biome.Precipitation.RAIN, (Biome.BiomeCategory)Biome.BiomeCategory.UNDERGROUND, (float)0.8f, (float)0.4f, (MobSpawnSettings.Builder)mobs, (BiomeGenerationSettings.Builder)settings, (Music)music);
        biome.setRegistryName(BIOME_NAME);
        return biome;
    }
}

