/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TradingPostRenderer
implements BlockEntityRenderer<TradingPostBlockEntity> {
    public TradingPostRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(TradingPostBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float ageInTicks = (float)tileEntityIn.time + partialTicks;
        float nextRotation = tileEntityIn.rot - tileEntityIn.oRot;
        while ((double)nextRotation >= Math.PI) {
            nextRotation = (float)((double)nextRotation - Math.PI * 2);
        }
        while ((double)nextRotation < -Math.PI) {
            nextRotation = (float)((double)nextRotation + Math.PI * 2);
        }
        float bookRotation = tileEntityIn.oRot + nextRotation * partialTicks;
        float bookOpen = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.oOpen, (float)tileEntityIn.open);
        this.renderItem(new ItemStack((ItemLike)Items.f_42616_), ageInTicks, bookOpen, bookRotation, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderItem(ItemStack stack, float ageInTicks, float bookOpen, float bookRotation, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.03125, 0.5);
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
        bookRotation *= -57.295776f;
        bookRotation -= 90.0f;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(bookRotation *= bookOpen));
        matrixStackIn.m_85837_(0.0, (double)bookOpen, Math.sin((double)bookOpen * Math.PI));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f * (bookOpen - 1.0f)));
        float hoveringHeight = (float)Math.sin(ageInTicks * 0.06f) * bookOpen * 0.2f;
        matrixStackIn.m_85837_(0.0, (double)hoveringHeight, 0.0);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, 0);
        matrixStackIn.m_85849_();
    }
}

