/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network.message;

import fuzs.puzzleslib.network.message.Message;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.trading.MerchantOffers;

public class S2CBuildOffersMessage
implements Message {
    private int containerId;
    private Int2IntOpenHashMap idToOfferCount;

    public S2CBuildOffersMessage() {
    }

    public S2CBuildOffersMessage(int containerId, Int2IntOpenHashMap idToOfferCount) {
        this.containerId = containerId;
        this.idToOfferCount = idToOfferCount;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.m_130130_(this.idToOfferCount.size());
        for (Int2IntMap.Entry entry : this.idToOfferCount.int2IntEntrySet()) {
            buf.writeInt(entry.getIntKey());
            buf.m_130130_(entry.getIntValue());
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        Int2IntOpenHashMap idToOfferCount = new Int2IntOpenHashMap();
        int length = buf.m_130242_();
        for (int i = 0; i < length; ++i) {
            idToOfferCount.put(buf.readInt(), buf.m_130242_());
        }
        this.idToOfferCount = idToOfferCount;
    }

    public BuildOffersHandler makeHandler() {
        return new BuildOffersHandler();
    }

    private static class BuildOffersHandler
    extends Message.PacketHandler<S2CBuildOffersMessage> {
        private BuildOffersHandler() {
        }

        public void handle(S2CBuildOffersMessage packet, Player player, Object gameInstance) {
            Minecraft mc = Minecraft.m_91087_();
            AbstractContainerMenu container = player.f_36096_;
            if (packet.containerId == container.f_38840_ && container instanceof TradingPostMenu && mc.f_91080_ instanceof TradingPostScreen) {
                ((TradingPostMenu)container).getTraders().buildOffers(packet.idToOfferCount);
                this.buildSearchTree(mc, ((TradingPostMenu)container).m_40075_());
                ((TradingPostScreen)mc.f_91080_).refreshSearchResults();
            }
        }

        private void buildSearchTree(Minecraft mc, MerchantOffers offers) {
            MutableSearchTree imutablesearchtree = mc.m_91171_(TradingPostClient.OFFER_SEARCH_TREE);
            imutablesearchtree.m_7716_();
            offers.forEach(arg_0 -> ((MutableSearchTree)imutablesearchtree).m_8080_(arg_0));
            imutablesearchtree.m_7729_();
        }
    }
}

