/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network.message;

import fuzs.puzzleslib.network.message.Message;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class S2CRemoveMerchantsMessage
implements Message {
    private int containerId;
    private IntSet merchantIds;

    public S2CRemoveMerchantsMessage() {
    }

    public S2CRemoveMerchantsMessage(int containerId, IntSet merchantIds) {
        this.containerId = containerId;
        this.merchantIds = merchantIds;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.m_130130_(this.merchantIds.size());
        IntIterator intIterator = this.merchantIds.iterator();
        while (intIterator.hasNext()) {
            int merchantId = (Integer)intIterator.next();
            buf.writeInt(merchantId);
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        int length = buf.m_130242_();
        IntOpenHashSet merchantIds = new IntOpenHashSet();
        for (int i = 0; i < length; ++i) {
            merchantIds.add(buf.readInt());
        }
        this.merchantIds = merchantIds;
    }

    public RemoveMerchantHandler makeHandler() {
        return new RemoveMerchantHandler();
    }

    private static class RemoveMerchantHandler
    extends Message.PacketHandler<S2CRemoveMerchantsMessage> {
        private RemoveMerchantHandler() {
        }

        public void handle(S2CRemoveMerchantsMessage packet, Player player, Object gameInstance) {
            AbstractContainerMenu container = player.f_36096_;
            if (packet.containerId == container.f_38840_ && container instanceof TradingPostMenu) {
                IntIterator intIterator = packet.merchantIds.iterator();
                while (intIterator.hasNext()) {
                    int merchantId = (Integer)intIterator.next();
                    ((TradingPostMenu)container).getTraders().removeMerchant(merchantId);
                }
            }
        }
    }
}

