/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block;

import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.mixin.accessor.VillagerAccessor;
import fuzs.tradingpost.registry.ModRegistry;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TradingPostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final Component CONTAINER_TITLE = new TranslatableComponent("container.trading_post");
    public static final Component NO_MERCHANT_FOUND = new TranslatableComponent("trading_post.no_trader_found");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG2 = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG3 = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape LEG4 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4});

    public TradingPostBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState oldState, LevelAccessor level, BlockPos newPos, BlockPos oldPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(newPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, oldState, level, newPos, oldPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TradingPostBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? TradingPostBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.get()), TradingPostBlockEntity::tickEmeraldAnimation) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        int verticalRange;
        int horizontalRange;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Vec3 blockCenterPos = Vec3.m_82512_((Vec3i)pos);
        List nearbyTraders = level.m_6443_(Entity.class, new AABB(blockCenterPos.m_82520_((double)(-(horizontalRange = ((ServerConfig)TradingPost.CONFIG.server()).horizontalRange)), (double)(-(verticalRange = ((ServerConfig)TradingPost.CONFIG.server()).verticalRange)), (double)(-horizontalRange)), blockCenterPos.m_82520_((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), this::canTrade);
        if (!nearbyTraders.isEmpty()) {
            ContainerLevelAccess access = ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos);
            MerchantCollection merchants = new MerchantCollection(access);
            for (Entity merchant : nearbyTraders) {
                if (merchant instanceof Villager) {
                    ((VillagerAccessor)merchant).callUpdateSpecialPrices(player);
                }
                merchants.addMerchant(merchant.m_142049_(), (Merchant)merchant);
            }
            merchants.m_7189_(player);
            merchants.buildOffers(merchants.getIdToOfferCountMap());
            Component title = this.getContainerTitle(level, pos);
            this.openTradingScreen(player, merchants, title, access);
        } else {
            player.m_5661_(NO_MERCHANT_FOUND, false);
        }
        return InteractionResult.CONSUME;
    }

    private boolean canTrade(Entity entity) {
        if (((ServerConfig)TradingPost.CONFIG.server()).traderBlacklist.contains(entity.m_6095_()) || entity.m_6095_().m_20609_(ModRegistry.BLACKLISTED_TRADERS_TAG)) {
            return false;
        }
        if (!entity.m_6084_() || !(entity instanceof Merchant) || ((Merchant)entity).m_7962_() != null || ((Merchant)entity).m_6616_().isEmpty()) {
            return false;
        }
        return !(entity instanceof LivingEntity) || !((LivingEntity)entity).m_5803_() && !((LivingEntity)entity).m_6162_();
    }

    private Component getContainerTitle(Level level, BlockPos pos) {
        BlockEntity tileentity = level.m_7702_(pos);
        return tileentity instanceof TradingPostBlockEntity ? ((Nameable)tileentity).m_5446_() : CONTAINER_TITLE;
    }

    private void openTradingScreen(Player player, MerchantCollection merchants, Component title, ContainerLevelAccess worldPosCallable) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((containerMenuId, playerInventory, playerEntity) -> new TradingPostMenu(containerMenuId, playerInventory, merchants, worldPosCallable), title)).ifPresent(containerId -> merchants.sendMerchantData(containerId, player));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = level.m_7702_(pos)) instanceof TradingPostBlockEntity) {
            ((TradingPostBlockEntity)tileentity).setCustomName(stack.m_41786_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter blockReader, BlockPos pos, PathComputationType pathType) {
        return false;
    }
}

