/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.fences;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcretePowderFence
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_199775_0_ -> ((Direction)p_199775_0_.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();
    private final VoxelShape[] renderShapes;

    public ConcretePowderFence(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.FALSE)).m_61124_((Property)EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)SOUTH, (Comparable)Boolean.FALSE)).m_61124_((Property)WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.renderShapes = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
        this.collisionShapes = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        for (BlockState blockstate : this.f_49792_.m_61056_()) {
            this.getIndex(blockstate);
        }
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    private static boolean shouldSolidify(BlockGetter getter, BlockPos pos, BlockState state) {
        return ConcretePowderFence.canSolidify(state) || ConcretePowderFence.touchesLiquid(getter, pos);
    }

    private static boolean touchesLiquid(BlockGetter getter, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = getter.m_8055_((BlockPos)mutable);
            if (direction == Direction.DOWN && !ConcretePowderFence.canSolidify(blockstate)) continue;
            mutable.m_122159_((Vec3i)pos, direction);
            blockstate = getter.m_8055_((BlockPos)mutable);
            if (!ConcretePowderFence.canSolidify(blockstate) || blockstate.m_60783_(getter, pos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)nodeHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)extensionBottom, (double)0.0, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)16.0, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    protected int getIndex(BlockState state) {
        return this.stateToIndex.computeIntIfAbsent((Object)state, p_223007_0_ -> {
            int i = 0;
            if (((Boolean)p_223007_0_.m_61143_((Property)NORTH)).booleanValue()) {
                i |= ConcretePowderFence.getMask(Direction.NORTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)EAST)).booleanValue()) {
                i |= ConcretePowderFence.getMask(Direction.EAST);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= ConcretePowderFence.getMask(Direction.SOUTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)WEST)).booleanValue()) {
                i |= ConcretePowderFence.getMask(Direction.WEST);
            }
            return i;
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.renderShapes[this.getIndex(state)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, getter, pos, context);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = this.isSameFence(state);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return !ConcretePowderFence.m_152463_((BlockState)state) && isSideSolid || flag || flag1;
    }

    private boolean isSameFence(BlockState state) {
        return state.m_60620_((Tag)BlockTags.f_13039_) && state.m_60620_((Tag)BlockTags.f_13098_) == this.m_49966_().m_60620_((Tag)BlockTags.f_13098_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            ItemStack itemstack = player.m_21120_(hand);
            return itemstack.m_41720_() == Items.f_42655_ ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return LeadItem.m_42829_((Player)player, (Level)level, (BlockPos)pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level getter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = getter.m_8055_(blockpos);
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142126_();
        BlockPos blockpos3 = blockpos.m_142128_();
        BlockPos blockpos4 = blockpos.m_142125_();
        BlockState blockstate1 = getter.m_8055_(blockpos1);
        BlockState blockstate2 = getter.m_8055_(blockpos2);
        BlockState blockstate3 = getter.m_8055_(blockpos3);
        BlockState blockstate4 = getter.m_8055_(blockpos4);
        BlockState finalState = ConcretePowderFence.shouldSolidify((BlockGetter)getter, blockpos, blockstate) ? this.getSolidifiedState() : this.m_49966_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)finalState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, blockstate1.m_60783_((BlockGetter)getter, blockpos1, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, blockstate2.m_60783_((BlockGetter)getter, blockpos2, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, blockstate3.m_60783_((BlockGetter)getter, blockpos3, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(blockstate4, blockstate4.m_60783_((BlockGetter)getter, blockpos4, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        BlockState state = ConcretePowderFence.touchesLiquid((BlockGetter)accessor, currentPos) ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)NORTH, (Comparable)((Boolean)stateIn.m_61143_((Property)NORTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)stateIn.m_61143_((Property)EAST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)stateIn.m_61143_((Property)SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)stateIn.m_61143_((Property)WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)stateIn.m_61143_((Property)WATERLOGGED))) : stateIn;
        return facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, facingState.m_60783_((BlockGetter)accessor, facingPos, facing.m_122424_()), facing.m_122424_()))) : super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }

    private BlockState getSolidifiedState() {
        String[] part = this.getRegistryName().m_135815_().split("_powder");
        String name = part[0] + part[1];
        return ((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)("vanillaextension:" + name), (char)':'))).m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public void m_142216_(Level level, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        FluidState fluidstate = level.m_6425_(pos);
        BlockPos blockpos1 = pos.m_142127_();
        BlockPos blockpos2 = pos.m_142126_();
        BlockPos blockpos3 = pos.m_142128_();
        BlockPos blockpos4 = pos.m_142125_();
        BlockState blockstate1 = level.m_8055_(blockpos1);
        BlockState blockstate2 = level.m_8055_(blockpos2);
        BlockState blockstate3 = level.m_8055_(blockpos3);
        BlockState blockstate4 = level.m_8055_(blockpos4);
        BlockState finalState = ConcretePowderFence.shouldSolidify((BlockGetter)level, pos, hitState) ? this.getSolidifiedState() : this.m_49966_();
        BlockState bs = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)finalState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, blockstate1.m_60783_((BlockGetter)level, blockpos1, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, blockstate2.m_60783_((BlockGetter)level, blockpos2, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, blockstate3.m_60783_((BlockGetter)level, blockpos3, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(blockstate4, blockstate4.m_60783_((BlockGetter)level, blockpos4, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        level.m_46597_(pos, bs);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

