/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.fences;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FallingFence
extends FallingBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_199775_0_ -> ((Direction)p_199775_0_.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();
    private final VoxelShape[] renderShapes;

    public FallingFence(BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapes = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        for (BlockState blockstate : this.f_49792_.m_61056_()) {
            this.getIndex(blockstate);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.FALSE)).m_61124_((Property)EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)SOUTH, (Comparable)Boolean.FALSE)).m_61124_((Property)WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.renderShapes = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    protected int getIndex(BlockState state) {
        return this.stateToIndex.computeIntIfAbsent((Object)state, p_223007_0_ -> {
            int i = 0;
            if (((Boolean)p_223007_0_.m_61143_((Property)NORTH)).booleanValue()) {
                i |= FallingFence.getMask(Direction.NORTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)EAST)).booleanValue()) {
                i |= FallingFence.getMask(Direction.EAST);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= FallingFence.getMask(Direction.SOUTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)WEST)).booleanValue()) {
                i |= FallingFence.getMask(Direction.WEST);
            }
            return i;
        });
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.renderShapes[this.getIndex(state)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, reader, pos, context);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            ItemStack itemstack = player.m_21120_(handIn);
            return itemstack.m_41720_() == Items.f_42655_ ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return LeadItem.m_42829_((Player)player, (Level)worldIn, (BlockPos)pos);
    }

    public boolean canConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = this.isSameFence(state);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return !FallingFence.m_152463_((BlockState)state) && isSideSolid || flag || flag1;
    }

    private boolean isSameFence(BlockState state) {
        return state.m_60620_((Tag)BlockTags.f_13039_) && state.m_60620_((Tag)BlockTags.f_13098_) == this.m_49966_().m_60620_((Tag)BlockTags.f_13098_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142126_();
        BlockPos blockpos3 = blockpos.m_142128_();
        BlockPos blockpos4 = blockpos.m_142125_();
        BlockState blockstate = iblockreader.m_8055_(blockpos1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos3);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate, blockstate.m_60783_((BlockGetter)iblockreader, blockpos1, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, blockstate1.m_60783_((BlockGetter)iblockreader, blockpos2, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, blockstate2.m_60783_((BlockGetter)iblockreader, blockpos3, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, blockstate3.m_60783_((BlockGetter)iblockreader, blockpos4, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.m_186460_(currentPos, (Block)this, this.m_7198_());
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, facingState.m_60783_((BlockGetter)worldIn, facingPos, facing.m_122424_()), facing.m_122424_()))) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        FluidState fluidstate = worldIn.m_6425_(pos);
        BlockPos blockpos1 = pos.m_142127_();
        BlockPos blockpos2 = pos.m_142126_();
        BlockPos blockpos3 = pos.m_142128_();
        BlockPos blockpos4 = pos.m_142125_();
        BlockState blockstate = worldIn.m_8055_(blockpos1);
        BlockState blockstate1 = worldIn.m_8055_(blockpos2);
        BlockState blockstate2 = worldIn.m_8055_(blockpos3);
        BlockState blockstate3 = worldIn.m_8055_(blockpos4);
        BlockState bs = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate, blockstate.m_60783_((BlockGetter)worldIn, blockpos1, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, blockstate1.m_60783_((BlockGetter)worldIn, blockpos2, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, blockstate2.m_60783_((BlockGetter)worldIn, blockpos3, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, blockstate3.m_60783_((BlockGetter)worldIn, blockpos4, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        worldIn.m_46597_(pos, bs);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirrorIn);
        };
    }
}

