/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.fences;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RedstoneOreFence
extends FenceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public RedstoneOreFence(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52310_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52311_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52312_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52313_, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    private static void interact(BlockState state, Level world, BlockPos pos) {
        RedstoneOreFence.spawnParticles(world, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.TRUE), 3);
        }
    }

    private static void spawnParticles(Level world, BlockPos worldIn) {
        double d0 = 0.5625;
        Random random = world.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = worldIn.m_142300_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.nextFloat();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)worldIn.m_123341_() + d1, (double)worldIn.m_123342_() + d2, (double)worldIn.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        RedstoneOreFence.interact(state, worldIn, pos);
        super.m_6256_(state, worldIn, pos, player);
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        RedstoneOreFence.interact(worldIn.m_8055_(pos), worldIn, pos);
        super.m_141947_(worldIn, pos, state, entityIn);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            RedstoneOreFence.spawnParticles(worldIn, pos);
        } else {
            RedstoneOreFence.interact(state, worldIn, pos);
        }
        if (player.m_21120_(handIn).m_41720_() == Items.f_42655_) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            return LeadItem.m_42829_((Player)player, (Level)worldIn, (BlockPos)pos);
        }
        ItemStack itemstack = player.m_21120_(handIn);
        return itemstack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, handIn, itemstack, hit).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 3);
        }
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? 1 + this.RANDOM.nextInt(5) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            RedstoneOreFence.spawnParticles(worldIn, pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52309_, f_52310_, f_52312_, f_52311_, f_52313_, LIT});
    }
}

